/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.services.deploy.deployers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.dtgov.common.Target;
import org.overlord.dtgov.services.deploy.deployers.AbstractDeployer;
import org.overlord.dtgov.services.i18n.Messages;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliDeployer
extends AbstractDeployer {
    private static Logger logger = LoggerFactory.getLogger(CliDeployer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deploy(BaseArtifactType artifact, Target target, SrampAtomApiClient client) throws Exception {
        String string;
        InputStream is;
        block6: {
            is = null;
            FileOutputStream os = null;
            CommandContext ctx = null;
            try {
                ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
                is = client.getArtifactContent(type, artifact.getUuid());
                String name = artifact.getName();
                int dot = name.lastIndexOf(".");
                File tmpFile = File.createTempFile(name.substring(0, dot), name.substring(dot));
                os = new FileOutputStream(tmpFile);
                IOUtils.copy((InputStream)is, (OutputStream)os);
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
                HashMap<String, String> undeployProperties = new HashMap<String, String>();
                undeployProperties.put("deploy.cli.host", target.getHost());
                undeployProperties.put("deploy.cli.port", String.valueOf(target.getPort()));
                undeployProperties.put("deploy.cli.name", tmpFile.getName());
                ctx = target.getUser() == null || target.getUser().isEmpty() ? CommandContextFactory.getInstance().newCommandContext() : CommandContextFactory.getInstance().newCommandContext(target.getUser(), target.getPassword().toCharArray());
                ctx.connectController(target.getHost(), target.getPort().intValue());
                StringBuilder commandString = new StringBuilder();
                commandString.append("deploy ");
                commandString.append(tmpFile.getAbsolutePath());
                if (target.isCliDomainMode()) {
                    String serverGroup = target.getCliServerGroup();
                    undeployProperties.put("deploy.cli.domainMode", "true");
                    if (serverGroup != null && serverGroup.trim().length() > 0) {
                        commandString.append(" --server-groups=");
                        commandString.append(serverGroup);
                        undeployProperties.put("deploy.cli.serverGroups", serverGroup);
                    } else {
                        commandString.append(" --all-server-groups");
                    }
                }
                ctx.handle(commandString.toString());
                tmpFile.delete();
                this.recordUndeploymentInfo(artifact, target, undeployProperties, client);
                logger.info(Messages.i18n.format("CliDeployer.deploymentSuccessfully", new Object[]{artifact.getUuid()}));
                string = target.getName() + " " + target.getHost();
                if (ctx == null) break block6;
            }
            catch (Throwable throwable) {
                if (ctx != null) {
                    ctx.terminateSession();
                }
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            ctx.terminateSession();
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(BaseArtifactType prevVersionArtifact, BaseArtifactType undeployInfo, Target target, SrampAtomApiClient client) throws Exception {
        CommandContext ctx = null;
        try {
            String deploymentName = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.cli.name");
            String cliHost = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.cli.host");
            Integer cliPort = new Integer(SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.cli.port"));
            boolean domainMode = "true".equals(SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.cli.domainMode"));
            ctx = target.getUser() == null || target.getUser().isEmpty() ? CommandContextFactory.getInstance().newCommandContext() : CommandContextFactory.getInstance().newCommandContext(target.getUser(), target.getPassword().toCharArray());
            ctx.connectController(cliHost, cliPort.intValue());
            if (domainMode) {
                ctx.handle("undeploy " + deploymentName + " --all-relevant-server-groups");
            } else {
                ctx.handle("undeploy " + deploymentName);
            }
        }
        finally {
            if (ctx != null) {
                ctx.terminateSession();
            }
        }
    }
}

