/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.services.deploy.deployers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.dtgov.common.Target;
import org.overlord.dtgov.services.deploy.deployers.AbstractDeployer;
import org.overlord.dtgov.services.i18n.Messages;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFileDeployer
extends AbstractDeployer {
    private static Logger logger = LoggerFactory.getLogger(CopyFileDeployer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deploy(BaseArtifactType artifact, Target target, SrampAtomApiClient client) throws Exception {
        String string;
        InputStream is = null;
        FileOutputStream os = null;
        try {
            File file;
            is = client.getArtifactContent(ArtifactType.valueOf((BaseArtifactType)artifact), artifact.getUuid());
            File deployDir = new File(target.getDeployDir());
            if (!deployDir.exists()) {
                logger.info(Messages.i18n.format("DeploymentResource.CreatingDeployDir", new Object[]{deployDir}));
                deployDir.mkdirs();
            }
            String deploymentName = artifact.getName();
            String mavenId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId");
            String version = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.version");
            String classifier = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.classifier");
            String type = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.type");
            if (mavenId != null) {
                StringBuilder nameBuilder = new StringBuilder();
                nameBuilder.append(mavenId);
                nameBuilder.append("-");
                nameBuilder.append(version);
                if (classifier != null) {
                    nameBuilder.append("-");
                    nameBuilder.append(classifier);
                }
                nameBuilder.append(".");
                nameBuilder.append(type);
                deploymentName = nameBuilder.toString();
            }
            if ((file = new File(deployDir + "/" + deploymentName)).exists()) {
                file.delete();
            }
            file.createNewFile();
            os = new FileOutputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("deploy.copy.file", file.getCanonicalPath());
            this.recordUndeploymentInfo(artifact, target, props, client);
            logger.info(Messages.i18n.format("CopyFileDeployer.deploymentSuccessfully", new Object[]{artifact.getUuid()}));
            string = file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    @Override
    public void undeploy(BaseArtifactType prevVersionArtifact, BaseArtifactType undeployInfo, Target target, SrampAtomApiClient client) {
        File failedFile;
        File deployFile;
        String deployedFile = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.copy.file");
        File file = new File(deployedFile);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
        if ((deployFile = new File(deployedFile + ".deployed")).isFile()) {
            deployFile.delete();
        }
        if ((failedFile = new File(deployedFile + ".failed")).isFile()) {
            failedFile.delete();
        }
    }
}

