/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.services.deploy.deployers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.MavenRepository;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.dtgov.common.Target;
import org.overlord.dtgov.services.MavenRepoUtil;
import org.overlord.dtgov.services.deploy.deployers.AbstractDeployer;
import org.overlord.dtgov.services.i18n.Messages;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDeployer
extends AbstractDeployer {
    private static Logger logger = LoggerFactory.getLogger(MavenDeployer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deploy(BaseArtifactType artifact, Target target, SrampAtomApiClient client) throws Exception {
        String string;
        InputStream isJar = null;
        InputStream isPom = null;
        FileOutputStream osJar = null;
        FileOutputStream osPom = null;
        InputStream isPom2 = null;
        try {
            String mavenArtifactId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId");
            String mavenGroupId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId");
            String mavenVersion = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.version");
            if (mavenArtifactId == null || mavenGroupId == null || mavenVersion == null) {
                throw new Exception(Messages.i18n.format("DeploymentResource.MissingMavenProps", new Object[]{artifact.getUuid()}));
            }
            String pomName = artifact.getName().substring(0, artifact.getName().lastIndexOf(".")) + ".pom";
            QueryResultSet queryResultSet = client.buildQuery("/s-ramp[@name = ?]").parameter(pomName).query();
            if (queryResultSet.size() == 0L) {
                throw new Exception(Messages.i18n.format("DeploymentResource.MissingPom", new Object[]{artifact.getUuid(), pomName}));
            }
            BaseArtifactType pomArtifact = null;
            for (ArtifactSummary artifactSummary2 : queryResultSet) {
                pomArtifact = client.getArtifactMetaData(artifactSummary2);
                String pomMavenArtifactId = SrampModelUtils.getCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.artifactId");
                String pomMavenGroupId = SrampModelUtils.getCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.groupId");
                String pomMavenVersion = SrampModelUtils.getCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.version");
                if (mavenArtifactId.equals(pomMavenArtifactId) && mavenGroupId.equals(pomMavenGroupId) && mavenVersion.equals(pomMavenVersion)) break;
                pomArtifact = null;
            }
            if (pomArtifact == null) {
                throw new Exception(Messages.i18n.format("DeploymentResource.IncorrectPom", new Object[]{artifact.getUuid(), pomName}));
            }
            ArtifactType pomType = ArtifactType.valueOf(pomArtifact);
            isPom = client.getArtifactContent(pomType, pomArtifact.getUuid());
            String name = pomArtifact.getName();
            File pomFile = new File(System.getProperty("java.io.tmpdir") + "/" + name);
            osPom = new FileOutputStream(pomFile);
            IOUtils.copy((InputStream)isPom, (OutputStream)osPom);
            IOUtils.closeQuietly((InputStream)isPom);
            IOUtils.closeQuietly((OutputStream)osPom);
            isJar = client.getArtifactContent(ArtifactType.valueOf((BaseArtifactType)artifact), artifact.getUuid());
            name = artifact.getName();
            File jarFile = new File(System.getProperty("java.io.tmpdir") + "/" + name);
            osJar = new FileOutputStream(jarFile);
            IOUtils.copy((InputStream)isJar, (OutputStream)osJar);
            IOUtils.closeQuietly((InputStream)isJar);
            IOUtils.closeQuietly((OutputStream)osJar);
            isPom2 = client.getArtifactContent(pomType, pomArtifact.getUuid());
            MavenRepoUtil util = new MavenRepoUtil();
            MavenRepository repo = util.getMavenReleaseRepo(target.getMavenUrl(), target.isReleaseEnabled(), target.isSnapshotEnabled(), isPom2);
            ReleaseIdImpl releaseId = new ReleaseIdImpl(mavenArtifactId, mavenGroupId, mavenVersion);
            repo.deployArtifact((ReleaseId)releaseId, jarFile, pomFile);
            logger.info(Messages.i18n.format("MavenDeployer.deploymentSuccessfully", new Object[]{artifact.getUuid()}));
            string = target.getMavenUrl();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isPom);
            IOUtils.closeQuietly(isPom2);
            IOUtils.closeQuietly(isJar);
            IOUtils.closeQuietly(osPom);
            IOUtils.closeQuietly(osJar);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)isPom);
        IOUtils.closeQuietly((InputStream)isPom2);
        IOUtils.closeQuietly((InputStream)isJar);
        IOUtils.closeQuietly((OutputStream)osPom);
        IOUtils.closeQuietly((OutputStream)osJar);
        return string;
    }

    @Override
    public void undeploy(BaseArtifactType prevVersionArtifact, BaseArtifactType undeployInfo, Target target, SrampAtomApiClient client) throws Exception {
    }
}

