/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.services.deploy.deployers;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.dtgov.common.Target;
import org.overlord.dtgov.services.deploy.deployers.AbstractDeployer;
import org.overlord.dtgov.services.i18n.Messages;
import org.overlord.dtgov.services.rhq.RHQDeployUtil;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RHQDeployer
extends AbstractDeployer {
    private static Logger logger = LoggerFactory.getLogger(RHQDeployer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deploy(BaseArtifactType artifact, Target target, SrampAtomApiClient client) throws Exception {
        String string;
        InputStream is = null;
        try {
            RHQDeployUtil rhqDeployUtil = new RHQDeployUtil(target.getUser(), target.getPassword(), target.getRhqBaseUrl(), target.getPort(), target.getRhqPluginName());
            Integer rhqGroupId = rhqDeployUtil.getGroupIdForGroup(target.getName());
            rhqDeployUtil.wipeArchiveIfNecessary(artifact.getName(), rhqGroupId);
            List<Integer> resourceIds = rhqDeployUtil.getServerIdsForGroup(rhqGroupId);
            is = client.getArtifactContent(ArtifactType.valueOf((BaseArtifactType)artifact), artifact.getUuid());
            byte[] fileContent = IOUtils.toByteArray((InputStream)is);
            for (Integer resourceId : resourceIds) {
                logger.info(Messages.i18n.format("DeploymentResource.DeployingToRHQ", new Object[]{artifact.getName(), resourceId}));
                rhqDeployUtil.deploy(resourceId, fileContent, artifact.getName());
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("deploy.rhq.groupId", String.valueOf(rhqGroupId));
            props.put("deploy.rhq.baseUrl", target.getRhqBaseUrl());
            props.put("deploy.rhq.port", String.valueOf(target.getPort()));
            props.put("deploy.rhq.name", artifact.getName());
            props.put("deploy.rhq.pluginName", target.getRhqPluginName());
            this.recordUndeploymentInfo(artifact, target, props, client);
            logger.info(Messages.i18n.format("RHQDeployer.deploymentSuccessfully", new Object[]{artifact.getUuid()}));
            string = target.getRhqBaseUrl();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    @Override
    public void undeploy(BaseArtifactType prevVersionArtifact, BaseArtifactType undeployInfo, Target target, SrampAtomApiClient client) throws Exception {
        if (target.getUser() == null || target.getPassword() == null || target.getUser().isEmpty() || target.getPassword().isEmpty()) {
            throw new Exception(Messages.i18n.format("DeploymentResource.MissingTargetCreds", new Object[]{target.getName()}));
        }
        String baseUrl = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.rhq.baseUrl");
        Integer port = new Integer(SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.rhq.port"));
        Integer rhqGroupId = new Integer(SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.rhq.groupId"));
        String artifactName = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.rhq.name");
        String rhqPluginName = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.rhq.pluginName");
        RHQDeployUtil rhqDeployUtil = new RHQDeployUtil(target.getUser(), target.getPassword(), baseUrl, port, rhqPluginName);
        rhqDeployUtil.wipeArchiveIfNecessary(artifactName, rhqGroupId);
    }
}

