/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.taskclient;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.overlord.dtgov.taskapi.types.FindTasksRequest;
import org.overlord.dtgov.taskapi.types.FindTasksResponse;
import org.overlord.dtgov.taskapi.types.TaskDataType;
import org.overlord.dtgov.taskapi.types.TaskType;
import org.overlord.dtgov.taskclient.ClientRequest;
import org.overlord.dtgov.taskclient.TaskApiClientException;
import org.overlord.dtgov.taskclient.auth.AuthenticationProvider;
import org.overlord.dtgov.taskclient.auth.BasicAuthenticationProvider;

public class TaskApiClient {
    private String endpoint;
    private AuthenticationProvider authProvider;
    private Locale locale;

    public TaskApiClient(String endpoint) {
        this.endpoint = endpoint;
        if (this.endpoint.endsWith("/")) {
            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 1);
        }
    }

    public TaskApiClient(String endpoint, String username, String password) throws TaskApiClientException {
        this(endpoint, new BasicAuthenticationProvider(username, password));
    }

    public TaskApiClient(String endpoint, AuthenticationProvider authenticationProvider) throws TaskApiClientException {
        this(endpoint);
        this.authProvider = authenticationProvider;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public FindTasksResponse findTasks(FindTasksRequest findTasksRequest) throws TaskApiClientException {
        try {
            String url = String.format("%1$s/find", this.endpoint);
            ClientRequest request = this.createClientRequest(url);
            request.body(MediaType.APPLICATION_XML_TYPE, findTasksRequest);
            ClientResponse<FindTasksResponse> response = request.post(FindTasksResponse.class);
            return (FindTasksResponse)response.getEntity();
        }
        catch (Throwable e) {
            throw new TaskApiClientException(e);
        }
    }

    public TaskType getTask(String taskId) throws TaskApiClientException {
        try {
            String url = String.format("%1$s/get/%2$s", this.endpoint, taskId);
            ClientRequest request = this.createClientRequest(url);
            ClientResponse<TaskType> response = request.get(TaskType.class);
            return (TaskType)response.getEntity();
        }
        catch (Throwable e) {
            throw new TaskApiClientException(e);
        }
    }

    public TaskType claimTask(String taskId) throws TaskApiClientException {
        try {
            String url = String.format("%1$s/claim/%2$s", this.endpoint, taskId);
            ClientRequest request = this.createClientRequest(url);
            ClientResponse<TaskType> response = request.get(TaskType.class);
            return (TaskType)response.getEntity();
        }
        catch (Throwable e) {
            throw new TaskApiClientException(e);
        }
    }

    public TaskType releaseTask(String taskId) throws TaskApiClientException {
        try {
            String url = String.format("%1$s/release/%2$s", this.endpoint, taskId);
            ClientRequest request = this.createClientRequest(url);
            ClientResponse<TaskType> response = request.get(TaskType.class);
            return (TaskType)response.getEntity();
        }
        catch (Throwable e) {
            throw new TaskApiClientException(e);
        }
    }

    public TaskType startTask(String taskId) throws TaskApiClientException {
        try {
            String url = String.format("%1$s/start/%2$s", this.endpoint, taskId);
            ClientRequest request = this.createClientRequest(url);
            ClientResponse<TaskType> response = request.get(TaskType.class);
            return (TaskType)response.getEntity();
        }
        catch (Throwable e) {
            throw new TaskApiClientException(e);
        }
    }

    public TaskType stopTask(String taskId) throws TaskApiClientException {
        try {
            String url = String.format("%1$s/stop/%2$s", this.endpoint, taskId);
            ClientRequest request = this.createClientRequest(url);
            ClientResponse<TaskType> response = request.get(TaskType.class);
            return (TaskType)response.getEntity();
        }
        catch (Throwable e) {
            throw new TaskApiClientException(e);
        }
    }

    public TaskType completeTask(String taskId, Map<String, String> taskData) throws TaskApiClientException {
        try {
            TaskDataType data = this.convertMapToTaskData(taskData);
            String url = String.format("%1$s/complete/%2$s", this.endpoint, taskId);
            ClientRequest request = this.createClientRequest(url);
            request.body(MediaType.APPLICATION_XML_TYPE, data);
            ClientResponse<TaskType> response = request.post(TaskType.class);
            return (TaskType)response.getEntity();
        }
        catch (Throwable e) {
            throw new TaskApiClientException(e);
        }
    }

    public TaskType failTask(String taskId, Map<String, String> taskData) throws TaskApiClientException {
        try {
            TaskDataType data = this.convertMapToTaskData(taskData);
            String url = String.format("%1$s/fail/%2$s", this.endpoint, taskId);
            ClientRequest request = this.createClientRequest(url);
            request.body(MediaType.APPLICATION_XML_TYPE, data);
            ClientResponse<TaskType> response = request.post(TaskType.class);
            return (TaskType)response.getEntity();
        }
        catch (Throwable e) {
            throw new TaskApiClientException(e);
        }
    }

    private TaskDataType convertMapToTaskData(Map<String, String> taskData) {
        TaskDataType data = new TaskDataType();
        for (Map.Entry<String, String> entry : taskData.entrySet()) {
            TaskDataType.Entry e = new TaskDataType.Entry();
            e.setKey(entry.getKey());
            e.setValue(entry.getValue());
            data.getEntry().add(e);
        }
        return data;
    }

    protected ClientRequest createClientRequest(String atomUrl) {
        ClientExecutor executor = this.createClientExecutor();
        ClientRequest request = new ClientRequest(atomUrl, executor);
        return request;
    }

    private ClientExecutor createClientExecutor() {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                Locale l = TaskApiClient.this.getLocale();
                if (l == null) {
                    l = Locale.getDefault();
                }
                request.addHeader("Accept-Language", l.toString());
            }
        });
        if (this.authProvider != null) {
            httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    TaskApiClient.this.authProvider.provideAuthentication(request);
                }
            });
        }
        return new ApacheHttpClient4Executor((HttpClient)httpClient);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

