/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.overlord.dtgov.common.exception.ConfigException;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.Query;
import org.overlord.sramp.governance.QueryAccessor;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.workflow.BpmManager;
import org.overlord.sramp.governance.workflow.WorkflowFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@RequestScoped
public class QueryExecutor {
    private static String GROUPED_BY = "groupedBy";
    private static Logger logger = LoggerFactory.getLogger(QueryExecutor.class);
    private static String MAVEN_PROPERTY_SIGNAL = "maven.property.signal";
    private static String SIGNAL_QUERY = "/s-ramp/ext/MavenPom[@maven.property.signal]";
    private static String WORKFLOW_PARAMETERS = "workflowParameters=";
    private static String WORKFLOW_PROCESS_ID = "workflowProcessId=";

    public static synchronized void execute() throws SrampClientException, MalformedURLException, ConfigException {
        Governance governance = new Governance();
        String deploymentId = governance.getGovernanceWorkflowGroup() + ":" + governance.getGovernanceWorkflowName() + ":" + governance.getGovernanceWorkflowVersion() + ":" + Governance.DEFAULT_GOVERNANCE_WORKFLOW_PACKAGE + ":" + Governance.DEFAULT_GOVERNANCE_WORKFLOW_KSESSION;
        BpmManager bpmManager = WorkflowFactory.newInstance();
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        QueryAccessor accesor = new QueryAccessor();
        for (Query query : accesor.getQueries()) {
            try {
                String srampQuery = query.getSrampQuery();
                QueryResultSet queryResultSet = client.query(srampQuery);
                if (queryResultSet.size() <= 0L) continue;
                for (ArtifactSummary artifactSummary : queryResultSet) {
                    BaseArtifactType artifact = client.getArtifactMetaData(artifactSummary.getType(), artifactSummary.getUuid());
                    List properties = artifact.getProperty();
                    String name = WORKFLOW_PROCESS_ID + query.getWorkflowId();
                    String value = WORKFLOW_PARAMETERS + query.getParameters();
                    String propertyName = null;
                    boolean hasPropertyName = false;
                    HashMap<String, String> propertyMap = new HashMap<String, String>();
                    for (Property property : properties) {
                        propertyMap.put(property.getPropertyName(), property.getPropertyValue());
                        if (!property.getPropertyName().startsWith(name) || !property.getPropertyValue().endsWith(value)) continue;
                        hasPropertyName = true;
                        break;
                    }
                    if (hasPropertyName) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug(Messages.i18n.format("QueryExecutor.ExistingWorkflowError", new Object[]{artifact.getUuid(), query.getWorkflowId(), query.getParameters()}));
                        continue;
                    }
                    logger.info(Messages.i18n.format("QueryExecutor.StartingWorkflow", new Object[]{query.getWorkflowId(), artifact.getUuid()}));
                    Map parameters = query.getParsedParameters();
                    parameters.put("ArtifactUuid", artifact.getUuid());
                    parameters.put("ArtifactName", artifact.getName());
                    if (artifact.getVersion() != null) {
                        parameters.put("ArtifactVersion", artifact.getVersion());
                    }
                    parameters.put("ArtifactCreatedBy", artifact.getCreatedBy());
                    parameters.put("ArtifactCreatedTimestamp", artifact.getCreatedTimestamp().toGregorianCalendar());
                    parameters.put("ArtifactLastModifiedBy", artifact.getLastModifiedBy());
                    parameters.put("ArtifactLastModifiedTimestamp", artifact.getLastModifiedTimestamp().toGregorianCalendar());
                    parameters.put("ArtifactType", artifactSummary.getType().getType());
                    long processInstanceId = bpmManager.newProcessInstance(deploymentId, query.getWorkflowId(), parameters);
                    propertyName = WORKFLOW_PROCESS_ID + query.getWorkflowId() + "_";
                    int i = 0;
                    while (propertyMap.keySet().contains(propertyName + i)) {
                        ++i;
                    }
                    artifact = client.getArtifactMetaData(artifactSummary.getType(), artifactSummary.getUuid());
                    String propValue = processInstanceId + "_" + WORKFLOW_PARAMETERS + query.getParameters();
                    SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)(propertyName + i), (String)propValue);
                    client.updateArtifactMetaData(artifact);
                }
            }
            catch (Exception e) {
                logger.error(Messages.i18n.format("QueryExecutor.ExceptionFor", new Object[]{query.getSrampQuery(), e.getMessage()}), (Throwable)e);
            }
        }
        try {
            QueryResultSet queryResultSet = client.query(SIGNAL_QUERY);
            if (queryResultSet.size() > 0L) {
                for (ArtifactSummary artifactSummary : queryResultSet) {
                    BaseArtifactType pomArtifact = client.getArtifactMetaData(artifactSummary.getType(), artifactSummary.getUuid());
                    for (Relationship relationship : pomArtifact.getRelationship()) {
                        if (!GROUPED_BY.equals(relationship.getRelationshipType())) continue;
                        for (Target target : relationship.getRelationshipTarget()) {
                            BaseArtifactType artifactGroup = client.getArtifactMetaData(target.getValue());
                            block11: for (Property property : artifactGroup.getProperty()) {
                                if (!property.getPropertyName().startsWith(WORKFLOW_PROCESS_ID)) continue;
                                String name = property.getPropertyName();
                                String value = property.getPropertyValue();
                                logger.info("Signalling Process " + name.substring(name.indexOf("=") + 1));
                                long processInstanceId = Long.valueOf(value.substring(0, value.indexOf("_")));
                                for (Property signalProperty : pomArtifact.getProperty()) {
                                    if (!signalProperty.getPropertyName().equals(MAVEN_PROPERTY_SIGNAL)) continue;
                                    String signalType = signalProperty.getPropertyValue();
                                    bpmManager.signalProcess(processInstanceId, signalType, (Object)pomArtifact.getUuid());
                                    signalProperty.setPropertyName(MAVEN_PROPERTY_SIGNAL + ".sent");
                                    client.updateArtifactMetaData(pomArtifact);
                                    continue block11;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(Messages.i18n.format("QueryExecutor.ExceptionFor", new Object[]{SIGNAL_QUERY, e.getMessage()}), (Throwable)e);
        }
    }
}

