/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.workflow.jbpm;

import java.util.Enumeration;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import org.overlord.dtgov.jbpm.ProcessBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/process")
@RequestScoped
public class ProcessService {
    @Inject
    @ApplicationScoped
    private ProcessBean processBean;
    private static Logger logger = LoggerFactory.getLogger(ProcessService.class);

    @POST
    @Path(value="start/{deploymentId}/{processId}")
    public String startProcess(@Context HttpServletRequest request, @PathParam(value="deploymentId") String deploymentId, @PathParam(value="processId") String processId) throws Exception {
        HashMap<String, String> context = new HashMap<String, String>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            context.put(name, request.getParameter(name));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Starting process %s %s with %d parameters", new Object[]{deploymentId, processId, context.size()});
        }
        Long processInstanceId = this.processBean.startProcess(deploymentId, processId, context);
        return String.valueOf(processInstanceId);
    }

    @PUT
    @Path(value="signal/{processInstanceId}/{signalType}/{event}")
    public void signalProcess(@PathParam(value="processInstanceId") Long processInstanceId, @PathParam(value="signalType") String signalType, @PathParam(value="event") String event) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Signalling processInstanceId %d with signalType %s and event $s", new Object[]{processInstanceId, signalType, event});
        }
        this.processBean.signalProcess(processInstanceId.longValue(), signalType, (Object)event);
    }
}

