/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.util.ArrayList;
import java.util.List;
import org.overlord.dtgov.common.Target;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.SrampClientQuery;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.TargetFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetAccessor {
    private static Logger logger = LoggerFactory.getLogger(TargetAccessor.class);

    public static List<Target> getTargets() {
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        SrampClientQuery query = client.buildQuery("/s-ramp/ext/DeploymentTarget");
        query = query.startIndex(0);
        try {
            QueryResultSet resultSet = query.query();
            return TargetFactory.asList((QueryResultSet)resultSet);
        }
        catch (SrampClientException e) {
            logger.error(Messages.i18n.format("TargetAccessor.ExceptionFor", new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (SrampAtomException e) {
            logger.error(Messages.i18n.format("TargetAccessor.ExceptionFor", new Object[]{e.getMessage()}), (Throwable)e);
        }
        return new ArrayList<Target>();
    }
}

