/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.taskapi;

import java.util.Comparator;
import java.util.Date;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;

public class TaskSummaryComparator
implements Comparator<TaskSummary> {
    private final String orderBy;
    private final boolean ascending;

    public TaskSummaryComparator(String orderBy, boolean ascending) {
        this.orderBy = orderBy;
        this.ascending = ascending;
    }

    @Override
    public int compare(TaskSummary task1, TaskSummary task2) {
        if (task1.getId() == task2.getId()) {
            return 0;
        }
        int order = 0;
        if (this.orderBy.equals("priority")) {
            order = new Integer(task1.getPriority()).compareTo(task2.getPriority());
        } else if (this.orderBy.equals("name")) {
            order = task1.getName().compareTo(task2.getName());
        } else if (this.orderBy.equals("owner")) {
            User owner1 = task1.getActualOwner();
            User owner2 = task2.getActualOwner();
            order = owner1 == null && owner2 == null ? 0 : (owner1 == null && owner2 != null ? -1 : (owner1 != null && owner2 == null ? 1 : owner1.getId().compareTo(owner2.getId())));
        } else if (this.orderBy.equals("status")) {
            order = task1.getStatus().toString().compareTo(task2.getStatus().toString());
        } else if (this.orderBy.equals("expirationDate")) {
            Date date1 = task1.getExpirationTime();
            Date date2 = task2.getExpirationTime();
            order = date1 == null && date2 == null ? 0 : (date1 == null && date2 != null ? -1 : (date1 != null && date2 == null ? 1 : date1.compareTo(date2)));
        }
        if (order == 0) {
            order = new Long(task1.getId()).compareTo(task2.getId());
        }
        if (!this.ascending) {
            order *= -1;
        }
        return order;
    }
}

