/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.codec.binary.Base64;
import org.overlord.dtgov.common.exception.ConfigException;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.QueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRAMPMonitor
extends TimerTask {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static Governance governance = new Governance();
    private static SRAMPMonitor srampMonitor = null;
    private static Timer timer = null;
    private static long interval = governance.getQueryInterval();
    private long acceptableLagTime = governance.getAcceptableLagtime();

    private SRAMPMonitor() {
    }

    public static synchronized SRAMPMonitor getInstance() {
        if (srampMonitor == null) {
            srampMonitor = new SRAMPMonitor();
            timer = new Timer(true);
            timer.scheduleAtFixedRate((TimerTask)srampMonitor, 60000L, interval);
        }
        return srampMonitor;
    }

    @Override
    public boolean cancel() {
        timer.cancel();
        return super.cancel();
    }

    @Override
    public synchronized void run() {
        try {
            if (this.firedOnTime(this.scheduledExecutionTime()) && this.isAppserverReady()) {
                long startTime = System.currentTimeMillis();
                QueryExecutor.execute();
                long endTime = System.currentTimeMillis();
                if (this.log.isDebugEnabled()) {
                    this.log.debug(Messages.i18n.format("SRAMPMonitor.QueryTiming", new Object[]{endTime - startTime}));
                }
                if (endTime - startTime > interval) {
                    this.log.debug(Messages.i18n.format("SRAMPMonitor.IntervalExceeded", new Object[]{interval, endTime - startTime}));
                } else {
                    this.log.debug(Messages.i18n.format("SRAMPMonitor.TaskTiming", new Object[]{endTime - startTime}));
                }
            } else {
                this.log.debug(Messages.i18n.format("SRAMPMonitor.NotReady", new Object[0]));
            }
        }
        catch (ConfigException confEx) {
            this.log.error(confEx.getMessage());
        }
        catch (SrampClientException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean firedOnTime(long scheduleExecutionTime) {
        long lagTime = System.currentTimeMillis() - scheduleExecutionTime;
        if (lagTime <= this.acceptableLagTime || this.acceptableLagTime < 0L) {
            return true;
        }
        this.log.debug(Messages.i18n.format("SRAMPMonitor.LaggingTimer", new Object[]{lagTime, this.acceptableLagTime}));
        return false;
    }

    private boolean isAppserverReady() throws MalformedURLException {
        boolean isReady = true;
        String serviceDocumentUrl = governance.getSrampUrl().toExternalForm() + "/s-ramp/servicedocument";
        isReady = this.urlExists(serviceDocumentUrl);
        if (!isReady) {
            this.log.debug(Messages.i18n.format("SRAMPMonitor.CannotConnect", new Object[]{governance.getSrampUrl().toExternalForm()}));
        }
        return isReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean urlExists(String checkUrl) {
        HttpURLConnection checkConnection = null;
        try {
            URL checkURL = new URL(checkUrl);
            checkConnection = (HttpURLConnection)checkURL.openConnection();
            checkConnection.setRequestMethod("HEAD");
            checkConnection.setConnectTimeout(10000);
            checkConnection.setReadTimeout(10000);
            this.addAuthorization(checkConnection);
            checkConnection.connect();
            boolean bl = checkConnection.getResponseCode() == 200;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (checkConnection != null) {
                checkConnection.disconnect();
            }
        }
    }

    private void addAuthorization(HttpURLConnection connection) {
        Governance governance = new Governance();
        String username = governance.getSrampUser();
        String password = governance.getSrampPassword();
        if (username != null && password != null) {
            String b64Auth = Base64.encodeBase64String((byte[])(username + ":" + password).getBytes()).trim();
            connection.setRequestProperty("Authorization", "Basic " + b64Auth);
        } else {
            this.log.warn(Messages.i18n.format("SRAMPMonitor.MissingCreds", new Object[0]));
        }
    }
}

