/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.dtgov.common.Target;
import org.overlord.dtgov.common.targets.TargetType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.TargetFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TargetFactory {
    public static Target toTarget(BaseArtifactType artifact) {
        String type = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.type");
        TargetType typeEnum = TargetType.value((String)type);
        String name = artifact.getName();
        String description = artifact.getDescription();
        String classifier = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.classifiers");
        Target target = null;
        if (typeEnum != null) {
            switch (1.$SwitchMap$org$overlord$dtgov$common$targets$TargetType[typeEnum.ordinal()]) {
                case 1: {
                    String rhq_baseUrl = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.baseUrl");
                    String rhq_pluginName = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.pluginName");
                    String rhq_user = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.user");
                    String rhq_password = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.password");
                    target = new Target(name, classifier, rhq_user, rhq_password, rhq_baseUrl, rhq_pluginName);
                    break;
                }
                case 2: {
                    String maven_isReleaseEnabled = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.releaseEnabled");
                    String maven_isSnapshotEnabled = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.snapshotEnabled");
                    String maven_user = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.user");
                    String maven_password = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.password");
                    String maven_repository = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.repositoryUrl");
                    boolean isReleaseEnabled = false;
                    boolean isSnapshotEnabled = false;
                    if (StringUtils.isNotBlank((String)maven_isReleaseEnabled) && maven_isReleaseEnabled.equals("true")) {
                        isReleaseEnabled = true;
                    }
                    if (StringUtils.isNotBlank((String)maven_isSnapshotEnabled) && maven_isSnapshotEnabled.equals("true")) {
                        isSnapshotEnabled = true;
                    }
                    target = new Target(name, classifier, maven_repository, maven_user, maven_password, isReleaseEnabled, isSnapshotEnabled);
                    break;
                }
                case 3: {
                    String cli_host = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.host");
                    String cli_port = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.port");
                    String cli_user = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.user");
                    String cli_password = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.password");
                    target = new Target(name, classifier, cli_user, cli_password, cli_host, cli_port);
                    break;
                }
                case 4: {
                    String deployDir = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.deployDir");
                    target = new Target(name, classifier, deployDir);
                    break;
                }
            }
        }
        if (target != null) {
            target.setDescription(description);
        }
        return target;
    }

    public static List<Target> asList(QueryResultSet resultSet) throws SrampClientException, SrampAtomException {
        ArrayList<Target> list = new ArrayList<Target>();
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        for (ArtifactSummary artifactSummary : resultSet) {
            BaseArtifactType artifact = client.getArtifactMetaData(artifactSummary.getUuid());
            Target target = TargetFactory.toTarget((BaseArtifactType)artifact);
            if (target == null) continue;
            list.add(target);
        }
        return list;
    }
}

