/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.ant.user;

import java.io.Console;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractGetPassword
extends Task {
    private String addproperty;
    private String message;
    private String confirmationMessage;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getConfirmationMessage() {
        return this.confirmationMessage;
    }

    public void setConfirmationMessage(String confirmationMessage) {
        this.confirmationMessage = confirmationMessage;
    }

    public String getAddproperty() {
        return this.addproperty;
    }

    public void setAddproperty(String addproperty) {
        this.addproperty = addproperty;
    }

    public void execute() throws BuildException {
        Console console = System.console();
        if (console == null) {
            throw new BuildException("\tConsole is not available");
        }
        if (this.addproperty == null || this.addproperty.equals("")) {
            throw new BuildException("\tThe output property is required for this task.");
        }
        if (this.message == null || this.message.equals("")) {
            throw new BuildException("\tThe message property is required for this task.");
        }
        if (this.confirmationMessage == null || this.confirmationMessage.equals("")) {
            throw new BuildException("\tThe confirmationMessage property is required for this task.");
        }
        String currentPropVal = this.getProject().getProperty(this.addproperty);
        if (currentPropVal == null || currentPropVal.trim().isEmpty()) {
            String password = "";
            String repeatedPassword = "";
            boolean validated = false;
            do {
                console.printf(this.message, new Object[0]);
                char[] readed = console.readPassword();
                password = new String(readed);
                boolean bl = validated = this.validatePassword(password) && this.validate(password);
                if (!validated) continue;
                console.printf(this.confirmationMessage, new Object[0]);
                readed = console.readPassword();
                repeatedPassword = new String(readed);
                if (password.equals(repeatedPassword)) continue;
                this.log("");
                this.log(" * Error *\nThe passwords you entered do not match. Please try again.");
                validated = false;
            } while (!validated);
            if (this.addproperty != null && !this.addproperty.equals("")) {
                this.getProject().setProperty(this.addproperty, password);
            }
        }
    }

    private boolean validatePassword(String password) {
        if (password == null || password.trim().equals("")) {
            this.log("");
            this.log(" * Error *\nThe password should not be empty");
            return false;
        }
        if (!password.matches(".*\\d+.*")) {
            this.log("");
            this.log(" * Error *\nThe password should include at least one number.");
            return false;
        }
        if (password.length() < 8) {
            this.log("");
            this.log(" * Error *\nThe length of the password should be at least 8 characters.");
            return false;
        }
        return true;
    }

    protected abstract boolean validate(String var1);
}

