/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.jboss7;

import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.codec.binary.Base64;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.overlord.commons.auth.jboss7.Messages;
import org.overlord.commons.auth.tomcat7.HttpRequestThreadLocalValve;
import org.overlord.commons.auth.util.SAMLBearerTokenUtil;
import org.picketlink.identity.federation.core.parsers.saml.SAMLAssertionParser;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.w3c.dom.Document;

public class SAMLBearerTokenLoginModule
extends AbstractServerLoginModule {
    private Set<String> allowedIssuers = new HashSet<String>();
    private String signatureRequired;
    private String keystorePath;
    private String keystorePassword;
    private String keyAlias;
    private String keyPassword;
    private Principal identity;
    private Set<String> roles = new HashSet<String>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        String val = (String)options.get("allowedIssuers");
        if (val != null) {
            String[] split;
            for (String issuer : split = val.split(",")) {
                if (issuer == null || issuer.trim().length() <= 0) continue;
                this.allowedIssuers.add(issuer);
            }
        }
        this.signatureRequired = (String)options.get("signatureRequired");
        this.keystorePath = (String)options.get("keystorePath");
        this.keystorePassword = (String)options.get("keystorePassword");
        this.keyAlias = (String)options.get("keyAlias");
        this.keyPassword = (String)options.get("keyPassword");
    }

    public boolean login() throws LoginException {
        try {
            String b64Data;
            byte[] dataBytes;
            String data;
            HttpServletRequest request = this.getCurrentRequest();
            String authorization = request.getHeader("Authorization");
            if (authorization != null && authorization.startsWith("Basic") && (data = new String(dataBytes = Base64.decodeBase64((String)(b64Data = authorization.substring(6))), "UTF-8")).startsWith("SAML-BEARER-TOKEN:")) {
                KeyPair keyPair;
                String assertionData = data.substring(18);
                Document samlAssertion = DocumentUtil.getDocument((String)assertionData);
                SAMLAssertionParser parser = new SAMLAssertionParser();
                DOMSource source = new DOMSource(samlAssertion);
                XMLEventReader xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(source);
                Object parsed = parser.parse(xmlEventReader);
                AssertionType assertion = (AssertionType)parsed;
                SAMLBearerTokenUtil.validateAssertion((AssertionType)assertion, (HttpServletRequest)request, this.allowedIssuers);
                if ("true".equals(this.signatureRequired) && !SAMLBearerTokenUtil.isSAMLAssertionSignatureValid((Document)samlAssertion, (KeyPair)(keyPair = this.getKeyPair(assertion)))) {
                    throw new LoginException(Messages.getString("SAMLBearerTokenLoginModule.InvalidSignature"));
                }
                this.consumeAssertion(assertion);
                this.loginOk = true;
                return true;
            }
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loginOk = false;
            return false;
        }
        return super.login();
    }

    private HttpServletRequest getCurrentRequest() throws LoginException {
        HttpServletRequest request = (HttpServletRequest)HttpRequestThreadLocalValve.TL_request.get();
        if (request == null) {
            try {
                request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
            }
            catch (Exception e) {
                request = null;
            }
        }
        if (request == null) {
            throw new LoginException("Failed to get current HTTP request.");
        }
        return request;
    }

    private KeyPair getKeyPair(AssertionType assertion) throws LoginException {
        KeyStore keystore = this.loadKeystore();
        try {
            return SAMLBearerTokenUtil.getKeyPair((KeyStore)keystore, (String)this.keyAlias, (String)this.keyPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException(Messages.getString("SAMLBearerTokenLoginModule.FailedToGetKeyPair") + this.keyAlias);
        }
    }

    private KeyStore loadKeystore() throws LoginException {
        try {
            return SAMLBearerTokenUtil.loadKeystore((String)this.keystorePath, (String)this.keystorePassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException("Error loading signature keystore: " + e.getMessage());
        }
    }

    private void consumeAssertion(AssertionType assertion) throws Exception {
        SubjectType samlSubjectType = assertion.getSubject();
        String samlSubject = ((NameIDType)samlSubjectType.getSubType().getBaseID()).getValue();
        this.identity = this.createIdentity(samlSubject);
        Set statements = assertion.getStatements();
        for (StatementAbstractType statement : statements) {
            if (!(statement instanceof AttributeStatementType)) continue;
            AttributeStatementType attrStatement = (AttributeStatementType)statement;
            List attributes = attrStatement.getAttributes();
            for (AttributeStatementType.ASTChoiceType astChoiceType : attributes) {
                if (astChoiceType.getAttribute() == null || !astChoiceType.getAttribute().getName().equals("Role")) continue;
                List values = astChoiceType.getAttribute().getAttributeValue();
                for (Object roleValue : values) {
                    if (roleValue == null) continue;
                    this.roles.add(roleValue.toString());
                }
            }
        }
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] groups = new Group[]{new SimpleGroup("Roles")};
        try {
            for (String role : this.roles) {
                groups[0].addMember(this.createIdentity(role));
            }
        }
        catch (Exception e) {
            throw new LoginException(Messages.getString("SAMLBearerTokenLoginModule.FailedToCreateGroupPrincipal") + e.getMessage());
        }
        return groups;
    }
}

