/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.jetty8;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.overlord.commons.auth.filters.SimplePrincipal;
import org.overlord.commons.auth.jetty8.HttpRequestThreadLocalFilter;
import org.overlord.commons.auth.jetty8.Jetty8SamlBearerTokenAuthFilter;
import org.overlord.commons.auth.jetty8.JettyAuthConstants;
import org.overlord.commons.auth.util.SAMLAssertionFactory;
import org.overlord.commons.auth.util.SAMLBearerTokenUtil;

public class Jetty8SAMLAssertionFactory
implements SAMLAssertionFactory {
    public boolean accept() {
        try {
            Class.forName("org.eclipse.jetty.server.Request");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public String createSAMLAssertion(String issuerName, String forService, int timeValidInMillis) {
        try {
            SimplePrincipal sp = Jetty8SamlBearerTokenAuthFilter.TL_principal.get();
            if (sp != null) {
                return SAMLBearerTokenUtil.createSAMLAssertion((Principal)sp, (Set)sp.getRoles(), (String)issuerName, (String)forService);
            }
            HttpServletRequest request = HttpRequestThreadLocalFilter.TL_request.get();
            Request jettyRequest = (Request)request;
            Authentication authentication = jettyRequest.getAuthentication();
            Authentication.User userAuth = (Authentication.User)authentication;
            UserIdentity userIdentity = userAuth.getUserIdentity();
            Principal userPrincipal = userIdentity.getUserPrincipal();
            Subject subject = userIdentity.getSubject();
            HashSet<String> roles = new HashSet<String>();
            for (String cname : JettyAuthConstants.ROLE_CLASSES) {
                try {
                    Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(cname);
                    Set<?> principals = subject.getPrincipals(c);
                    for (Principal p : principals) {
                        roles.add(p.getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            return SAMLBearerTokenUtil.createSAMLAssertion((Principal)userPrincipal, roles, (String)issuerName, (String)forService, (int)timeValidInMillis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

