/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.jetty8;

import java.io.IOException;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.eclipse.jetty.plus.jaas.JAASLoginService;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.overlord.commons.auth.util.SAMLBearerTokenUtil;
import org.picketlink.identity.federation.core.parsers.saml.SAMLAssertionParser;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.w3c.dom.Document;

public class SAMLBearerTokenLoginService
extends JAASLoginService {
    private static final Logger LOG = Log.getLogger(JAASLoginService.class);
    private Set<String> allowedIssuers;
    private boolean signatureRequired;
    private String keystorePath;
    private String keystorePassword;
    private String keyAlias;
    private String keyPassword;

    public UserIdentity login(String username, Object credentials) {
        String password = credentials.toString();
        if (password.startsWith("SAML-BEARER-TOKEN:")) {
            return this.doSamlLogin(username, password.substring(18));
        }
        return super.login(username, credentials);
    }

    private UserIdentity doSamlLogin(String username, String samlAssertionData) {
        try {
            KeyPair keyPair;
            Document samlAssertion = DocumentUtil.getDocument((String)samlAssertionData);
            SAMLAssertionParser parser = new SAMLAssertionParser();
            XMLEventReader xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(new StringReader(samlAssertionData));
            Object parsed = parser.parse(xmlEventReader);
            AssertionType assertion = (AssertionType)parsed;
            SAMLBearerTokenUtil.validateAssertion((AssertionType)assertion, (HttpServletRequest)AbstractHttpConnection.getCurrentConnection().getRequest(), this.allowedIssuers);
            if (this.signatureRequired && !SAMLBearerTokenUtil.isSAMLAssertionSignatureValid((Document)samlAssertion, (KeyPair)(keyPair = this.getKeyPair(assertion)))) {
                throw new IOException("Invalid signature found on SAML assertion!");
            }
            return this.consumeAssertion(assertion);
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), new Object[0]);
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private KeyPair getKeyPair(AssertionType assertion) throws IOException {
        KeyStore keystore = this.loadKeystore();
        try {
            return SAMLBearerTokenUtil.getKeyPair((KeyStore)keystore, (String)this.keyAlias, (String)this.keyPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Failed to get KeyPair when validating SAML assertion signature.  Alias: " + this.keyAlias);
        }
    }

    private KeyStore loadKeystore() throws IOException {
        try {
            return SAMLBearerTokenUtil.loadKeystore((String)this.keystorePath, (String)this.keystorePassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Error loading signature keystore: " + e.getMessage());
        }
    }

    private UserIdentity consumeAssertion(AssertionType assertion) throws Exception {
        SubjectType samlSubjectType = assertion.getSubject();
        String samlSubject = ((NameIDType)samlSubjectType.getSubType().getBaseID()).getValue();
        ArrayList<String> roles = new ArrayList<String>();
        Set statements = assertion.getStatements();
        for (StatementAbstractType statement : statements) {
            if (!(statement instanceof AttributeStatementType)) continue;
            AttributeStatementType attrStatement = (AttributeStatementType)statement;
            List attributes = attrStatement.getAttributes();
            for (AttributeStatementType.ASTChoiceType astChoiceType : attributes) {
                if (astChoiceType.getAttribute() == null || !astChoiceType.getAttribute().getName().equals("Role")) continue;
                List values = astChoiceType.getAttribute().getAttributeValue();
                for (Object roleValue : values) {
                    if (roleValue == null) continue;
                    roles.add(roleValue.toString());
                }
            }
        }
        Subject subject = new Subject();
        SAMLUserPrincipal principal = new SAMLUserPrincipal(samlSubject);
        subject.getPrincipals().add(principal);
        for (String role : roles) {
            subject.getPrincipals().add(new SAMLRolePrincipal(role));
        }
        return this._identityService.newUserIdentity(subject, (Principal)principal, roles.toArray(new String[roles.size()]));
    }

    public Set<String> getAllowedIssuers() {
        return this.allowedIssuers;
    }

    public void setAllowedIssuers(Set<String> allowedIssuers) {
        this.allowedIssuers = allowedIssuers;
    }

    public void setAllowedIssuers(String[] allowedIssuers) {
        this.allowedIssuers = new HashSet<String>();
        for (String issuer : allowedIssuers) {
            this.allowedIssuers.add(issuer);
        }
    }

    public boolean isSignatureRequired() {
        return this.signatureRequired;
    }

    public void setSignatureRequired(boolean signatureRequired) {
        this.signatureRequired = signatureRequired;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    private static class SAMLRolePrincipal
    extends SAMLUserPrincipal {
        public SAMLRolePrincipal(String name) {
            super(name);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SAMLRolePrincipal)) {
                return false;
            }
            return this.getName().equals(((SAMLRolePrincipal)o).getName());
        }
    }

    private static class SAMLUserPrincipal
    implements Principal {
        private final String name;

        public SAMLUserPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

