/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.tomcat7;

import java.io.IOException;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.commons.codec.binary.Base64;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.overlord.commons.auth.util.SAMLBearerTokenUtil;
import org.picketlink.identity.federation.core.parsers.saml.SAMLAssertionParser;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.w3c.dom.Document;

public class SAMLBearerTokenAuthenticator
extends BasicAuthenticator {
    private Set<String> allowedIssuers;
    private boolean signatureRequired;
    private String keystorePath;
    private String keystorePassword;
    private String keyAlias;
    private String keyPassword;

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        MessageBytes authorization;
        Principal principal = request.getUserPrincipal();
        if (principal == null && (authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization")) != null) {
            authorization.toBytes();
            ByteChunk authorizationBC = authorization.getByteChunk();
            if (authorizationBC.startsWithIgnoreCase("basic ", 0)) {
                authorizationBC.setOffset(authorizationBC.getOffset() + 6);
                String b64Data = new String(authorizationBC.getBuffer(), authorizationBC.getOffset(), authorizationBC.getLength());
                byte[] decoded = Base64.decodeBase64((String)b64Data);
                String data = new String(decoded, "UTF-8");
                if (data.startsWith("SAML-BEARER-TOKEN:")) {
                    try {
                        KeyPair keyPair;
                        String assertionData = data.substring(18);
                        Document samlAssertion = DocumentUtil.getDocument((String)assertionData);
                        SAMLAssertionParser parser = new SAMLAssertionParser();
                        XMLEventReader xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(new StringReader(assertionData));
                        Object parsed = parser.parse(xmlEventReader);
                        AssertionType assertion = (AssertionType)parsed;
                        SAMLBearerTokenUtil.validateAssertion((AssertionType)assertion, (HttpServletRequest)request, this.allowedIssuers);
                        if (this.signatureRequired && !SAMLBearerTokenUtil.isSAMLAssertionSignatureValid((Document)samlAssertion, (KeyPair)(keyPair = this.getKeyPair(assertion)))) {
                            throw new IOException("Invalid signature found on SAML assertion!");
                        }
                        principal = this.consumeAssertion(assertion);
                        if (principal != null) {
                            this.register(request, response, principal, "BASIC", principal.getName(), null);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }
            authorizationBC.setOffset(authorizationBC.getOffset() - 6);
        }
        return super.authenticate(request, response, config);
    }

    private KeyPair getKeyPair(AssertionType assertion) throws IOException {
        KeyStore keystore = this.loadKeystore();
        try {
            return SAMLBearerTokenUtil.getKeyPair((KeyStore)keystore, (String)this.keyAlias, (String)this.keyPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Failed to get KeyPair when validating SAML assertion signature.  Alias: " + this.keyAlias);
        }
    }

    private KeyStore loadKeystore() throws IOException {
        try {
            return SAMLBearerTokenUtil.loadKeystore((String)this.keystorePath, (String)this.keystorePassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Error loading signature keystore: " + e.getMessage());
        }
    }

    private Principal consumeAssertion(AssertionType assertion) throws Exception {
        SubjectType samlSubjectType = assertion.getSubject();
        String samlSubject = ((NameIDType)samlSubjectType.getSubType().getBaseID()).getValue();
        ArrayList<String> roles = new ArrayList<String>();
        Set statements = assertion.getStatements();
        for (StatementAbstractType statement : statements) {
            if (!(statement instanceof AttributeStatementType)) continue;
            AttributeStatementType attrStatement = (AttributeStatementType)statement;
            List attributes = attrStatement.getAttributes();
            for (AttributeStatementType.ASTChoiceType astChoiceType : attributes) {
                if (astChoiceType.getAttribute() == null || !astChoiceType.getAttribute().getName().equals("Role")) continue;
                List values = astChoiceType.getAttribute().getAttributeValue();
                for (Object roleValue : values) {
                    if (roleValue == null) continue;
                    roles.add(roleValue.toString());
                }
            }
        }
        GenericPrincipal identity = new GenericPrincipal(samlSubject, "", roles);
        return identity;
    }

    public String getAllowedIssuers() {
        return this.allowedIssuers.toString();
    }

    public void setAllowedIssuers(String allowedIssuers) {
        allowedIssuers = this.interpolate(allowedIssuers);
        if (this.allowedIssuers == null) {
            this.allowedIssuers = new HashSet<String>();
        }
        this.allowedIssuers.clear();
        if (allowedIssuers != null) {
            String[] issuers;
            for (String issuer : issuers = allowedIssuers.split(",")) {
                this.allowedIssuers.add(issuer.trim());
            }
        }
    }

    public String getSignatureRequired() {
        return String.valueOf(this.signatureRequired);
    }

    public void setSignatureRequired(String signatureRequired) {
        signatureRequired = this.interpolate(signatureRequired);
        this.signatureRequired = Boolean.valueOf(signatureRequired);
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePath(String keystorePath) {
        String home;
        if ((keystorePath = this.interpolate(keystorePath)) != null && !keystorePath.startsWith("/") && keystorePath.charAt(2) != ':' && (home = System.getProperty("catalina.home")) != null) {
            keystorePath = home + "/" + keystorePath;
        }
        this.keystorePath = keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword = this.interpolate(keystorePassword);
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias = this.interpolate(keyAlias);
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword = this.interpolate(keyPassword);
    }

    private String interpolate(String value) {
        if (value != null && value.startsWith("${")) {
            int idx = value.indexOf("::");
            if (idx < 3) {
                return value;
            }
            String propName = value.substring(2, idx);
            String defaultValue = value.substring(idx + 2, value.length() - 1);
            return System.getProperty(propName, defaultValue);
        }
        return value;
    }
}

