/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.config.configurator;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.overlord.commons.config.configurator.AbstractPropertiesFileConfigurator;
import org.overlord.commons.config.configurator.Configurator;
import org.overlord.commons.services.ServiceRegistryUtil;

@Component(name="Fuse Configurator", immediate=true)
@Service(value={Configurator.class})
public class FuseConfigurator
extends AbstractPropertiesFileConfigurator {
    private FabricService fabricService;

    private FabricService getFabricService() {
        if (this.fabricService == null) {
            try {
                this.fabricService = (FabricService)ServiceRegistryUtil.getSingleService(FabricService.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.fabricService;
    }

    @Override
    public boolean accept() {
        String karafDir = System.getProperty("karaf.home");
        return karafDir != null || this.getFabricService() != null;
    }

    @Override
    public Configuration provideConfiguration(String configName, Long refreshDelay) throws ConfigurationException {
        if (this.getFabricService() != null) {
            byte[] properties = this.getProperties(configName);
            if (properties != null) {
                OutputStream os = null;
                try {
                    File f = File.createTempFile("temp.overlord", "properties");
                    f.deleteOnExit();
                    os = new FileOutputStream(f);
                    IOUtils.write((byte[])properties, (OutputStream)os);
                    PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(f);
                    return propertiesConfiguration;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return super.provideConfiguration(configName, refreshDelay);
        }
        return super.provideConfiguration(configName, refreshDelay);
    }

    protected byte[] getProperties(String urlFile) {
        if (this.getFabricService() != null && this.getFabricService().getCurrentContainer() != null && this.getFabricService().getCurrentContainer().getOverlayProfile() != null) {
            Profile profile = this.getFabricService().getCurrentContainer().getOverlayProfile();
            byte[] returned = profile.getFileConfiguration(urlFile);
            String content = new String(returned);
            content = StringUtils.replace((String)content, (String)"\\{", (String)"{");
            content = StringUtils.replace((String)content, (String)"\\}", (String)"}");
            return content.getBytes();
        }
        return null;
    }

    @Override
    protected URL findConfigUrl(String configName) {
        String karafDir = System.getProperty("karaf.home");
        if (karafDir != null) {
            File dirFile = new File(karafDir, "etc");
            return this.findConfigUrlInDirectory(dirFile, configName);
        }
        return null;
    }
}

