/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.config;

import java.io.File;
import java.net.URL;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.overlord.commons.config.SystemPropertiesConfiguration;
import org.overlord.commons.config.configurator.Configurator;
import org.overlord.commons.config.crypt.CryptLookup;
import org.overlord.commons.config.fabric.ContainerLookup;
import org.overlord.commons.config.fabric.ProfileLookup;
import org.overlord.commons.config.vault.VaultLookup;
import org.overlord.commons.services.ServiceRegistryUtil;

public class ConfigurationFactory {
    private static boolean globalLookupsRegistered = false;

    public static Configuration createConfig(String configFileOverride, String standardConfigFileName, Long refreshDelay, String defaultConfigPath, Class<?> defaultConfigLoader) {
        ConfigurationFactory.registerGlobalLookups();
        try {
            Set configurators;
            CompositeConfiguration compositeConfig = new CompositeConfiguration();
            compositeConfig.addConfiguration((Configuration)new SystemPropertiesConfiguration());
            if (configFileOverride != null) {
                File file = new File(configFileOverride);
                if (file.isFile()) {
                    compositeConfig.addConfiguration((Configuration)new PropertiesConfiguration(file));
                } else {
                    URL resource = Thread.currentThread().getContextClassLoader().getResource(configFileOverride);
                    if (resource == null && defaultConfigLoader != null) {
                        resource = defaultConfigLoader.getResource(configFileOverride);
                    }
                    if (resource != null) {
                        compositeConfig.addConfiguration((Configuration)new PropertiesConfiguration(resource));
                    } else {
                        throw new ConfigurationException("Failed to find config file: " + configFileOverride);
                    }
                }
            }
            if (!(configurators = ServiceRegistryUtil.getServices(Configurator.class)).isEmpty()) {
                Configuration providedConfig;
                for (Configurator configurator : configurators) {
                    if (!configurator.accept() || (providedConfig = configurator.provideConfiguration(standardConfigFileName, refreshDelay)) == null) continue;
                    compositeConfig.addConfiguration(providedConfig);
                }
                if (!standardConfigFileName.equals("overlord.properties")) {
                    for (Configurator configurator : configurators) {
                        if (!configurator.accept() || (providedConfig = configurator.provideConfiguration("overlord.properties", refreshDelay)) == null) continue;
                        compositeConfig.addConfiguration(providedConfig);
                    }
                }
            }
            if (defaultConfigPath != null) {
                compositeConfig.addConfiguration((Configuration)new PropertiesConfiguration(defaultConfigLoader.getResource(defaultConfigPath)));
            }
            return compositeConfig;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized void registerGlobalLookups() {
        if (!globalLookupsRegistered) {
            ConfigurationInterpolator.registerGlobalLookup((String)"vault", (StrLookup)new VaultLookup());
            ConfigurationInterpolator.registerGlobalLookup((String)"crypt", (StrLookup)new CryptLookup());
            ConfigurationInterpolator.registerGlobalLookup((String)"container", (StrLookup)new ContainerLookup());
            ConfigurationInterpolator.registerGlobalLookup((String)"profile", (StrLookup)new ProfileLookup());
            globalLookupsRegistered = true;
        }
    }
}

