/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.config.configurator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.overlord.commons.config.configurator.Configurator;

public abstract class AbstractConfigurator
implements Configurator {
    @Override
    public void addConfiguration(CompositeConfiguration config, String configFileOverride, String standardConfigFileName, Long refreshDelay) throws ConfigurationException {
        URL url;
        if (!this.setConfigurationFromServerApi((Configuration)config, configFileOverride, standardConfigFileName) && (url = this.findConfig(configFileOverride, standardConfigFileName)) != null) {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(url);
            config.addConfiguration((Configuration)propertiesConfiguration);
            FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
            fileChangedReloadingStrategy.setRefreshDelay(refreshDelay.longValue());
            propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
        }
    }

    protected abstract URL getServerConfigUrl(String var1) throws MalformedURLException;

    protected boolean setConfigurationFromServerApi(Configuration config, String configFileOverride, String standardConfigFileName) {
        return false;
    }

    protected URL findConfig(String configFileOverride, String standardConfigFileName) {
        block5: {
            try {
                if (configFileOverride != null) {
                    URL fromClasspath = Thread.currentThread().getContextClassLoader().getResource(configFileOverride);
                    if (fromClasspath != null) {
                        return fromClasspath;
                    }
                    File file = new File(configFileOverride);
                    if (file.isFile()) {
                        return file.toURI().toURL();
                    }
                    break block5;
                }
                return this.getServerConfigUrl(standardConfigFileName);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

