/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.config.configurator;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.overlord.commons.config.configurator.AbstractConfigurator;
import org.overlord.commons.config.configurator.Configurator;
import org.overlord.commons.services.ServiceRegistryUtil;

@Component(name="The Fabric Configurator", immediate=true)
@Service(value={Configurator.class})
public final class FabricConfigurator
extends AbstractConfigurator {
    private FabricService fabricService;

    private FabricService getFabricService() {
        if (this.fabricService == null) {
            try {
                this.fabricService = (FabricService)ServiceRegistryUtil.getSingleService(FabricService.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.fabricService;
    }

    protected Map<String, String> getProperties(String urlFile) {
        if (this.getFabricService() != null && this.getFabricService().getCurrentContainer() != null && this.getFabricService().getCurrentContainer().getOverlayProfile() != null) {
            Profile profile = this.getFabricService().getCurrentContainer().getOverlayProfile();
            String file_name = "";
            file_name = urlFile.contains(".") ? urlFile.substring(0, urlFile.lastIndexOf(".")) : urlFile;
            Map toReturn = profile.getConfiguration(file_name);
            return toReturn;
        }
        return null;
    }

    @Override
    protected boolean setConfigurationFromServerApi(Configuration config, String configFileOverride, String standardConfigFileName) {
        Map<String, String> props = null;
        props = StringUtils.isNotBlank((String)standardConfigFileName) ? this.getProperties(standardConfigFileName) : this.getProperties(configFileOverride);
        if (props != null && !props.isEmpty()) {
            for (String key : props.keySet()) {
                config.addProperty(key, (Object)props.get(key));
            }
            return true;
        }
        return false;
    }

    @Override
    protected URL getServerConfigUrl(String standardConfigFileName) {
        URL url = null;
        try {
            url = new URL("profile:" + standardConfigFileName);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }
}

