/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.eap.extensions.config;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.overlord.commons.eap.extensions.config.Attribute;
import org.overlord.commons.eap.extensions.config.ConfigurationDefinition;
import org.overlord.commons.eap.extensions.config.ConfigurationPropertyDefinition;
import org.overlord.commons.eap.extensions.config.Element;
import org.overlord.commons.eap.extensions.config.Namespace;

public class SubsystemParser_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public static final SubsystemParser_1_0 INSTANCE = new SubsystemParser_1_0();

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "overlord-configuration");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OVERLORD_CONFIGURATION_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONFIGURATIONS: {
                            this.parseConfigurations(reader, address, list);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void parseConfigurations(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OVERLORD_CONFIGURATION_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONFIGURATION: {
                            this.parseConfiguration(reader, parentAddress, list);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void parseConfiguration(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int attrCount = reader.getAttributeCount();
        block9: for (int i = 0; i < attrCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    ConfigurationDefinition.NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode address = parentAddress.clone();
        address.add("configuration", name);
        address.protect();
        operation.get("address").set(address);
        list.add(operation);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OVERLORD_CONFIGURATION_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PROPERTIES: {
                            this.parseProperties(reader, address, list);
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void parseProperties(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OVERLORD_CONFIGURATION_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PROPERTY: {
                            this.parseProperty(reader, parentAddress, list);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void parseProperty(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        String propertyName = null;
        String propertyValue = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int attrCount = reader.getAttributeCount();
        block4: for (int i = 0; i < attrCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    propertyName = value;
                    ConfigurationPropertyDefinition.NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case VALUE: {
                    propertyValue = value;
                    ConfigurationPropertyDefinition.VALUE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (propertyName == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        if (propertyValue == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("value"));
        }
        ModelNode address = parentAddress.clone();
        address.add("property", propertyName);
        address.protect();
        operation.get("address").set(address);
        list.add(operation);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        streamWriter.writeStartElement("configurations");
        if (node.hasDefined("configuration")) {
            List configurations = node.get("configuration").asList();
            for (ModelNode configuration : configurations) {
                ModelNode configChild = configuration.get(0);
                streamWriter.writeStartElement("configuration");
                this.writeAttributeIfDefined(streamWriter, configChild, "name");
                if (configChild.hasDefined("property")) {
                    List properties = configChild.get("property").asList();
                    for (ModelNode property : properties) {
                        streamWriter.writeStartElement("property");
                        ModelNode propertyChild = property.get(0);
                        this.writeAttributeIfDefined(streamWriter, propertyChild, "name");
                        this.writeAttributeIfDefined(streamWriter, propertyChild, "value");
                        streamWriter.writeEndElement();
                    }
                }
                streamWriter.writeEndElement();
            }
        }
        streamWriter.writeEndElement();
        streamWriter.writeEndElement();
    }

    private void writeAttributeIfDefined(XMLExtendedStreamWriter streamWriter, ModelNode node, String name) throws XMLStreamException {
        ModelNode attr;
        if (node.has(name) && (attr = node.get(name)).isDefined()) {
            streamWriter.writeAttribute(name, attr.asString());
        }
    }
}

