/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.maven.plugin;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.overlord.commons.maven.plugin.GenerateFeaturesXmlMojo;

public class GenerateFeaturesXmlMojoTest {
    @Test
    public void testFormatArtifactAsBundle() throws Exception {
        GenerateFeaturesXmlMojo mojo = (GenerateFeaturesXmlMojo)Mockito.spy((Object)new GenerateFeaturesXmlMojo());
        ((GenerateFeaturesXmlMojo)Mockito.doReturn((Object)true).when((Object)mojo)).isBundle((Artifact)Matchers.any(Artifact.class));
        DefaultArtifact artifact = new DefaultArtifact("org.overlord.commons", "test-artifact", "0.0.1", "", "jar", "", null);
        mojo.formatArtifactAsBundle((Artifact)artifact);
        String bundle = mojo.formatArtifactAsBundle((Artifact)artifact);
        Assert.assertEquals((Object)"mvn:org.overlord.commons/test-artifact/0.0.1", (Object)bundle);
        ((GenerateFeaturesXmlMojo)Mockito.doReturn((Object)false).when((Object)mojo)).isBundle((Artifact)Matchers.any(Artifact.class));
        MavenProject project = (MavenProject)Mockito.mock(MavenProject.class);
        ((GenerateFeaturesXmlMojo)Mockito.doReturn((Object)project).when((Object)mojo)).resolveProject((Artifact)Matchers.any(Artifact.class));
        Mockito.when((Object)project.getName()).thenReturn((Object)"Test Artifact");
        artifact = new DefaultArtifact("org.overlord.commons", "test-artifact", "0.0.1", "", "jar", "", null);
        mojo.formatArtifactAsBundle((Artifact)artifact);
        bundle = mojo.formatArtifactAsBundle((Artifact)artifact);
        Assert.assertEquals((Object)"wrap:mvn:org.overlord.commons/test-artifact/0.0.1$Bundle-SymbolicName=org.overlord.commons.test-artifact&Bundle-Version=0.0.1&Bundle-Name=Test Artifact", (Object)bundle);
        ((GenerateFeaturesXmlMojo)Mockito.doReturn((Object)false).when((Object)mojo)).isBundle((Artifact)Matchers.any(Artifact.class));
        ((GenerateFeaturesXmlMojo)Mockito.doReturn((Object)project).when((Object)mojo)).resolveProject((Artifact)Matchers.any(Artifact.class));
        Mockito.when((Object)project.getName()).thenReturn((Object)"${extension.name} API v.${spec.version}");
        artifact = new DefaultArtifact("org.overlord.commons", "test-artifact", "0.0.1", "", "jar", "", null);
        mojo.formatArtifactAsBundle((Artifact)artifact);
        bundle = mojo.formatArtifactAsBundle((Artifact)artifact);
        Assert.assertEquals((Object)"wrap:mvn:org.overlord.commons/test-artifact/0.0.1$Bundle-SymbolicName=org.overlord.commons.test-artifact&Bundle-Version=0.0.1", (Object)bundle);
    }
}

