/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.overlord.commons.services.ServiceRegistry;

public class OSGiServiceRegistry
implements ServiceRegistry {
    public static final String OSGI_ENABLED_PROP = "overlord-commons-config.osgi-enabled";

    @Override
    public <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        Object service;
        block3: {
            service = null;
            try {
                BundleContext context = FrameworkUtil.getBundle(serviceInterface).getBundleContext();
                ServiceReference[] serviceReferences = context.getServiceReferences(serviceInterface.getName(), null);
                if (serviceReferences == null) break block3;
                if (serviceReferences.length == 1) {
                    service = context.getService(serviceReferences[0]);
                    break block3;
                }
                throw new IllegalStateException("Multiple implementation registered for service: " + serviceInterface);
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)service;
    }

    @Override
    public <T> Set<T> getServices(Class<T> serviceInterface) {
        HashSet<Object> services = new HashSet<Object>();
        try {
            BundleContext context = FrameworkUtil.getBundle(serviceInterface).getBundleContext();
            ServiceReference[] serviceReferences = context.getServiceReferences(serviceInterface.getName(), null);
            if (serviceReferences != null) {
                for (ServiceReference serviceReference : serviceReferences) {
                    Object service = context.getService(serviceReference);
                    services.add(service);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        return services;
    }
}

