/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.overlord.commons.services.ServiceRegistry;

public class ServiceLoaderServiceRegistry
implements ServiceRegistry {
    private Map<Class<?>, Set<?>> servicesCache = new HashMap();
    private Map<Class<?>, Object> serviceCache = new HashMap();

    @Override
    public <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        if (this.serviceCache.containsKey(serviceInterface)) {
            return (T)this.serviceCache.get(serviceInterface);
        }
        Object rval = null;
        Iterator<T> i$ = ServiceLoader.load(serviceInterface).iterator();
        if (i$.hasNext()) {
            T service = i$.next();
            if (rval == null) {
                rval = service;
                this.serviceCache.put(serviceInterface, rval);
            } else {
                throw new IllegalStateException("Multiple implementations found for service: " + serviceInterface);
            }
        }
        return (T)rval;
    }

    @Override
    public <T> Set<T> getServices(Class<T> serviceInterface) {
        if (this.servicesCache.containsKey(serviceInterface)) {
            return this.servicesCache.get(serviceInterface);
        }
        HashSet<T> services = new HashSet<T>();
        for (T service : ServiceLoader.load(serviceInterface)) {
            services.add(service);
        }
        this.servicesCache.put(serviceInterface, services);
        return services;
    }
}

