/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.overlord.commons.services.AbstractServiceRegistry;
import org.overlord.commons.services.Messages;

public class ServiceLoaderServiceRegistry
extends AbstractServiceRegistry {
    private Map<Class<?>, Set<?>> servicesCache = new HashMap();

    @Override
    public <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        T rval = null;
        Set<T> services = this.getServices(serviceInterface);
        if (services.size() > 1) {
            throw new IllegalStateException(Messages.getString("ServiceLoaderServiceRegistry.MultipleImplsFound") + serviceInterface);
        }
        if (!services.isEmpty()) {
            rval = services.iterator().next();
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<T> getServices(Class<T> serviceInterface) {
        Map<Class<?>, Set<?>> map = this.servicesCache;
        synchronized (map) {
            if (this.servicesCache.containsKey(serviceInterface)) {
                return this.servicesCache.get(serviceInterface);
            }
            LinkedHashSet<T> services = new LinkedHashSet<T>();
            try {
                for (T service : ServiceLoader.load(serviceInterface)) {
                    this.init(service);
                    services.add(service);
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                // empty catch block
            }
            this.servicesCache.put(serviceInterface, services);
            return services;
        }
    }
}

