/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.overlord.commons.services.Messages;
import org.overlord.commons.services.ServiceRegistry;

public class OSGiServiceRegistry
implements ServiceRegistry {
    @Override
    public <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        Object service;
        block3: {
            service = null;
            try {
                BundleContext context;
                ServiceReference[] serviceReferences;
                Bundle bundle = FrameworkUtil.getBundle(serviceInterface);
                if (bundle == null || (serviceReferences = (context = bundle.getBundleContext()).getServiceReferences(serviceInterface.getName(), null)) == null) break block3;
                if (serviceReferences.length == 1) {
                    service = context.getService(serviceReferences[0]);
                    break block3;
                }
                throw new IllegalStateException(Messages.getString("OSGiServiceRegistry.MultipleImplsRegistered") + serviceInterface);
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)service;
    }

    @Override
    public <T> Set<T> getServices(Class<T> serviceInterface) {
        HashSet<Object> services = new HashSet<Object>();
        try {
            Bundle bundle = FrameworkUtil.getBundle(serviceInterface);
            if (bundle != null) {
                ServiceReference[] serviceReferences;
                BundleContext context;
                if (bundle.getState() == 4) {
                    bundle.start();
                }
                if ((context = bundle.getBundleContext()) != null && (serviceReferences = context.getServiceReferences(serviceInterface.getName(), null)) != null) {
                    for (ServiceReference serviceReference : serviceReferences) {
                        Object service = context.getService(serviceReference);
                        services.add(service);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return services;
    }
}

