/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.overlord.commons.services.AbstractServiceRegistry;
import org.overlord.commons.services.Messages;
import org.overlord.commons.services.ServiceListener;

public class OSGiServiceRegistry
extends AbstractServiceRegistry {
    private static final Logger LOG = Logger.getLogger(OSGiServiceRegistry.class.getName());
    private Map<ServiceListener<?>, ServiceListenerAdapter<?>> _listeners = new HashMap();
    private List<Object> _services = new ArrayList<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init(Object service) {
        List<Object> list = this._services;
        synchronized (list) {
            if (!this._services.contains(service)) {
                super.init(service);
            }
            this._services.add(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close(Object service) {
        List<Object> list = this._services;
        synchronized (list) {
            if (this._services.remove(service) && !this._services.contains(service)) {
                super.close(service);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        Object service = null;
        try {
            Bundle bundle = FrameworkUtil.getBundle(serviceInterface);
            if (bundle == null) return (T)service;
            BundleContext context = bundle.getBundleContext();
            if (context != null) {
                ServiceReference[] serviceReferences = context.getServiceReferences(serviceInterface.getName(), null);
                if (serviceReferences == null) return (T)service;
                if (serviceReferences.length != 1) throw new IllegalStateException(Messages.getString("OSGiServiceRegistry.MultipleImplsRegistered") + serviceInterface);
                service = context.getService(serviceReferences[0]);
                this.init(service);
                return (T)service;
            } else {
                LOG.warning(Messages.format("OSGiServiceRegistry.MissingBundleContext", serviceInterface));
            }
            return (T)service;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Set<T> getServices(Class<T> serviceInterface) {
        HashSet<Object> services = new HashSet<Object>();
        try {
            Bundle bundle = FrameworkUtil.getBundle(serviceInterface);
            if (bundle != null) {
                ServiceReference[] serviceReferences;
                BundleContext context;
                if (bundle.getState() == 4) {
                    bundle.start();
                }
                if ((context = bundle.getBundleContext()) != null && (serviceReferences = context.getServiceReferences(serviceInterface.getName(), null)) != null) {
                    for (ServiceReference serviceReference : serviceReferences) {
                        Object service = context.getService(serviceReference);
                        this.init(service);
                        services.add(service);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addServiceListener(Class<T> serviceInterface, ServiceListener<T> listener) {
        Map<ServiceListener<?>, ServiceListenerAdapter<?>> map = this._listeners;
        synchronized (map) {
            this._listeners.put(listener, new ServiceListenerAdapter<T>(serviceInterface, listener, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void removeServiceListener(ServiceListener<T> listener) {
        Map<ServiceListener<?>, ServiceListenerAdapter<?>> map = this._listeners;
        synchronized (map) {
            ServiceListenerAdapter<?> adapter = this._listeners.get(listener);
            if (adapter != null) {
                adapter.close();
                this._listeners.remove(listener);
            }
        }
    }

    public static class ServiceListenerAdapter<T> {
        private Class<T> _serviceInterface;
        private ServiceListener<T> _serviceListener;
        private OSGiServiceRegistry _serviceRegistry;
        private org.osgi.framework.ServiceListener _osgiListener = null;

        public ServiceListenerAdapter(Class<T> serviceInterface, ServiceListener<T> listener, OSGiServiceRegistry reg) {
            this._serviceInterface = serviceInterface;
            this._serviceListener = listener;
            this._serviceRegistry = reg;
            this.init();
        }

        protected void init() {
            Bundle bundle = FrameworkUtil.getBundle(this._serviceInterface);
            if (bundle != null) {
                final BundleContext context = bundle.getBundleContext();
                this._osgiListener = new org.osgi.framework.ServiceListener(){

                    public void serviceChanged(ServiceEvent ev) {
                        ServiceReference sr = ev.getServiceReference();
                        Object service = context.getService(sr);
                        switch (ev.getType()) {
                            case 1: {
                                ServiceListenerAdapter.this._serviceRegistry.init(service);
                                ServiceListenerAdapter.this._serviceListener.registered(service);
                                break;
                            }
                            case 4: {
                                ServiceListenerAdapter.this._serviceListener.unregistered(service);
                                ServiceListenerAdapter.this._serviceRegistry.close(service);
                                break;
                            }
                        }
                    }
                };
                String filter = "(objectclass=" + this._serviceInterface.getName() + ")";
                try {
                    context.addServiceListener(this._osgiListener, filter);
                }
                catch (InvalidSyntaxException e) {
                    LOG.log(Level.SEVERE, Messages.format("OSGiServiceRegistry.FailedToAddListener", this._serviceInterface.getName()));
                }
                try {
                    ServiceReference[] srefs = context.getServiceReferences(this._serviceInterface.getName(), null);
                    if (srefs != null) {
                        for (int i = 0; i < srefs.length; ++i) {
                            Object service = context.getService(srefs[i]);
                            this._serviceRegistry.init(service);
                            this._serviceListener.registered(service);
                        }
                    }
                }
                catch (InvalidSyntaxException e) {
                    LOG.log(Level.SEVERE, Messages.format("OSGiServiceRegistry.FailedToAddServiceReferences", this._serviceInterface.getName()));
                }
            }
        }

        public void close() {
        }
    }
}

