/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.resourceLoader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.resourceLoader.ResourceLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BundleResourceLoader
implements ResourceLoader {
    private static final Logger log = Logger.getLogger((String)"org.jboss.solder.resources");

    public InputStream getResourceAsStream(String name) {
        String strippedName = BundleResourceLoader.getStrippedName(name);
        Bundle bundle2 = FrameworkUtil.getBundle(this.getClass());
        URL resource = bundle2.getResource(strippedName);
        if (resource != null) {
            log.trace((Object)("Loaded resource from bundle: " + strippedName));
            try {
                return resource.openStream();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public URL getResource(String name) {
        String strippedName = BundleResourceLoader.getStrippedName(name);
        Bundle bundle2 = FrameworkUtil.getBundle(this.getClass());
        URL resource = bundle2.getResource(strippedName);
        return resource;
    }

    public Set<URL> getResources(String name) {
        HashSet<URL> urls = new HashSet<URL>();
        String strippedName = BundleResourceLoader.getStrippedName(name);
        Bundle bundle2 = FrameworkUtil.getBundle(this.getClass());
        try {
            Enumeration urlEnum = bundle2.getResources(strippedName);
            if (urlEnum != null) {
                while (urlEnum.hasMoreElements()) {
                    urls.add((URL)urlEnum.nextElement());
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return urls;
    }

    public Collection<InputStream> getResourcesAsStream(String name) {
        HashSet<InputStream> resources = new HashSet<InputStream>();
        String strippedName = BundleResourceLoader.getStrippedName(name);
        Bundle bundle2 = FrameworkUtil.getBundle(this.getClass());
        try {
            Enumeration urlEnum = bundle2.getResources(strippedName);
            if (urlEnum != null) {
                while (urlEnum.hasMoreElements()) {
                    resources.add(((URL)urlEnum.nextElement()).openStream());
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return resources;
    }

    public int getPrecedence() {
        return 10;
    }

    private static String getStrippedName(String name) {
        return name.startsWith("/") ? name.substring(1) : name;
    }
}

