/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.config.xml.fieldset;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.solder.config.xml.fieldset.FieldValue;
import org.jboss.solder.config.xml.fieldset.FieldValueObject;
import org.jboss.solder.config.xml.model.ValueXmlItem;
import org.jboss.solder.config.xml.util.TypeReader;
import org.jboss.solder.properties.Property;

public class CollectionFieldSet
implements FieldValueObject {
    private final Property<Object> field;
    private final List<FieldValue> values;
    private final Class<?> elementType;
    private final Class<? extends Collection> collectionType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CollectionFieldSet(Property<Object> field, List<ValueXmlItem> items) {
        this.field = field;
        this.values = new ArrayList<FieldValue>();
        Type type = field.getBaseType();
        if (!(type instanceof ParameterizedType)) throw new RuntimeException("Could not determine element type for " + field.getDeclaringClass().getName() + "." + field.getName());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType.getRawType() == Collection.class) {
            this.collectionType = LinkedHashSet.class;
        } else if (parameterizedType.getRawType() == List.class) {
            this.collectionType = ArrayList.class;
        } else if (parameterizedType.getRawType() == Set.class) {
            this.collectionType = LinkedHashSet.class;
        } else if (parameterizedType.getRawType() == SortedSet.class) {
            this.collectionType = TreeSet.class;
        } else if (parameterizedType.getRawType() == HashSet.class) {
            this.collectionType = HashSet.class;
        } else if (parameterizedType.getRawType() == ArrayList.class) {
            this.collectionType = ArrayList.class;
        } else if (parameterizedType.getRawType() == LinkedList.class) {
            this.collectionType = LinkedList.class;
        } else if (parameterizedType.getRawType() == LinkedHashSet.class) {
            this.collectionType = LinkedHashSet.class;
        } else {
            if (parameterizedType.getRawType() != TreeSet.class) throw new RuntimeException("Could not determine element type for " + field.getDeclaringClass().getName() + "." + field.getName());
            this.collectionType = TreeSet.class;
        }
        this.elementType = TypeReader.readClassFromType(parameterizedType.getActualTypeArguments()[0]);
        for (ValueXmlItem i : items) {
            this.values.add(i.getValue());
        }
    }

    @Override
    public void setValue(Object instance, CreationalContext<?> ctx, BeanManager manager) {
        try {
            Collection res = this.collectionType.newInstance();
            this.field.setValue(instance, res);
            for (int i = 0; i < this.values.size(); ++i) {
                res.add(this.values.get(i).value(this.elementType, ctx, manager));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

