/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.ui.header;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.overlord.commons.config.OverlordConfig;

public class OverlordHeaderDataJS
extends HttpServlet {
    private static final long serialVersionUID = -4982770016769892713L;
    private static final OverlordConfig config = new OverlordConfig();
    private String appId;
    private String logoutUrl;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        this.appId = config.getInitParameter("app-id");
        if (this.appId == null || this.appId.trim().length() == 0) {
            throw new ServletException("Application identifier (app-id) parameter missing from Overlord Header Data JS servlet.");
        }
        this.logoutUrl = config.getInitParameter("logout-url");
        if (this.logoutUrl == null || this.logoutUrl.trim().length() == 0) {
            this.logoutUrl = "?GLO=true";
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.noCache(response);
        response.setContentType("text/javascript");
        try {
            List<TabInfo> tabs = this.getTabs(request);
            response.getOutputStream().write("var OVERLORD_HEADER_DATA = ".getBytes("UTF-8"));
            JsonFactory f = new JsonFactory();
            JsonGenerator g = f.createJsonGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);
            g.useDefaultPrettyPrinter();
            g.writeStartObject();
            g.writeStringField("username", this.getRemoteUser(request));
            g.writeStringField("logoutLink", this.getLogoutLink(request));
            g.writeStringField("primaryBrand", this.getPrimaryBrand(tabs));
            g.writeStringField("secondaryBrand", this.getSecondaryBrand(tabs));
            g.writeArrayFieldStart("tabs");
            for (TabInfo tabInfo : tabs) {
                g.writeStartObject();
                g.writeStringField("app-id", tabInfo.appId);
                g.writeStringField("href", tabInfo.href);
                g.writeStringField("label", tabInfo.label);
                g.writeBooleanField("active", tabInfo.active);
                g.writeEndObject();
            }
            g.writeEndArray();
            g.writeEndObject();
            g.flush();
            response.getOutputStream().write(";".getBytes("UTF-8"));
            g.close();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String getRemoteUser(HttpServletRequest request) {
        return request.getRemoteUser() == null ? "<anonymous>" : request.getRemoteUser();
    }

    private String getLogoutLink(HttpServletRequest request) {
        return this.logoutUrl;
    }

    private String getPrimaryBrand(List<TabInfo> tabs) {
        for (TabInfo tabInfo : tabs) {
            if (!tabInfo.active) continue;
            return tabInfo.primaryBrand;
        }
        return "";
    }

    private String getSecondaryBrand(List<TabInfo> tabs) {
        for (TabInfo tabInfo : tabs) {
            if (!tabInfo.active) continue;
            return tabInfo.secondaryBrand;
        }
        return "";
    }

    private List<TabInfo> getTabs(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        ArrayList<TabInfo> tabs = (ArrayList<TabInfo>)session.getAttribute("overlord-tabs");
        if (tabs == null) {
            tabs = new ArrayList<TabInfo>();
            this.getConfiguredTabs(tabs);
            session.setAttribute("overlord-tabs", tabs);
        }
        return tabs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConfiguredTabs(List<TabInfo> tabs) throws Exception {
        HashMap uiHeaders = config.getUiHeaders();
        if (uiHeaders == null) {
            uiHeaders = new HashMap();
        }
        TreeSet<TabInfo> sortedTabs = new TreeSet<TabInfo>(new Comparator<TabInfo>(){

            @Override
            public int compare(TabInfo o1, TabInfo o2) {
                return o1.appId.compareTo(o2.appId);
            }
        });
        File configDir = this.getConfigDir();
        if (configDir != null) {
            Collection configFiles = FileUtils.listFiles((File)configDir, (String[])new String[]{"properties"}, (boolean)false);
            for (File configFile : configFiles) {
                if (!configFile.getCanonicalPath().endsWith("-overlordapp.properties")) continue;
                FileReader reader = new FileReader(configFile);
                try {
                    Properties configProps = new Properties();
                    configProps.load(new FileReader(configFile));
                    String appId = configProps.getProperty("overlordapp.app-id");
                    if (uiHeaders.containsKey(appId)) continue;
                    String href = configProps.getProperty("overlordapp.href");
                    String primaryBrand = configProps.getProperty("overlordapp.primary-brand");
                    String secondaryBrand = configProps.getProperty("overlordapp.secondary-brand");
                    String label = configProps.getProperty("overlordapp.label");
                    HashMap<String, String> app = new HashMap<String, String>();
                    app.put("href", href);
                    app.put("primary-brand", primaryBrand);
                    app.put("secondary-brand", secondaryBrand);
                    app.put("label", label);
                    uiHeaders.put(appId, app);
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
        }
        for (String appId : uiHeaders.keySet()) {
            Map app = (Map)uiHeaders.get(appId);
            String href = (String)app.get("href");
            String primaryBrand = (String)app.get("primary-brand");
            String secondaryBrand = (String)app.get("secondary-brand");
            String label = (String)app.get("label");
            sortedTabs.add(new TabInfo(appId, primaryBrand, secondaryBrand, href, label, appId.equals(this.appId)));
        }
        tabs.addAll(sortedTabs);
    }

    private File getConfigDir() {
        File dirFile;
        File dirFile2;
        File dirFile3;
        File dirFile4;
        File dirFile5;
        File dirFile6;
        File configDir = null;
        String configDirProp = System.getProperty("org.overlord.apps.config-dir");
        if (configDirProp != null && (configDir = new File(configDirProp)).isDirectory()) {
            return configDir;
        }
        String jbossConfigDir = System.getProperty("jboss.server.config.dir");
        if (jbossConfigDir != null && (dirFile6 = new File(jbossConfigDir)).isDirectory() && (configDir = new File(dirFile6, "overlord-apps")).isDirectory()) {
            return configDir;
        }
        String jbossConfigUrl = System.getProperty("jboss.server.config.url");
        if (jbossConfigUrl != null && (dirFile5 = new File(jbossConfigUrl)).isDirectory() && (configDir = new File(dirFile5, "overlord-apps")).isDirectory()) {
            return configDir;
        }
        String jbossDataDir = System.getProperty("jboss.server.data.dir");
        if (jbossDataDir != null && (dirFile4 = new File(jbossDataDir)).isDirectory() && (configDir = new File(dirFile4, "overlord-apps")).isDirectory()) {
            return configDir;
        }
        String catalinaHomeDir = System.getProperty("catalina.home");
        if (catalinaHomeDir != null && (dirFile3 = new File(catalinaHomeDir, "conf")).isDirectory() && (configDir = new File(dirFile3, "overlord-apps")).isDirectory()) {
            return configDir;
        }
        String karafDir = System.getProperty("karaf.home");
        if (karafDir != null && (dirFile2 = new File(karafDir, "etc")).isDirectory() && (configDir = new File(dirFile2, "overlord-apps")).isDirectory()) {
            return configDir;
        }
        String jettyDir = System.getProperty("jetty.home");
        if (jettyDir != null && (dirFile = new File(jettyDir, "etc")).isDirectory() && (configDir = new File(dirFile, "overlord-apps")).isDirectory()) {
            return configDir;
        }
        return null;
    }

    private void noCache(HttpServletResponse response) {
        Date now = new Date();
        response.setDateHeader("Date", now.getTime());
        response.setDateHeader("Expires", now.getTime() - 86400000L);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
    }

    private static final class TabInfo
    implements Serializable {
        private static final long serialVersionUID = 7628110060136125387L;
        public final String appId;
        public final String primaryBrand;
        public final String secondaryBrand;
        public final String href;
        public final String label;
        public final boolean active;

        public TabInfo(String appId, String primaryBrand, String secondaryBrand, String href, String label, boolean active) {
            this.appId = appId;
            this.primaryBrand = primaryBrand;
            this.secondaryBrand = secondaryBrand;
            this.href = href;
            this.label = label;
            this.active = active;
        }
    }
}

