/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.ui.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public class OverlordHeaderResources
implements Filter {
    private static final Map<String, String> FILE_TYPES = new HashMap<String, String>();
    private static final Map<String, Boolean> EXISTS_CHECK = new HashMap<String, Boolean>();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        String path = "/META-INF/resources" + httpReq.getServletPath();
        if (path.endsWith("/")) {
            chain.doFilter(request, response);
            return;
        }
        Boolean exists = EXISTS_CHECK.get(path);
        if (exists != null && !exists.booleanValue()) {
            chain.doFilter(request, response);
            return;
        }
        ClassLoader cl = this.getClass().getClassLoader();
        URL resourceURL = cl.getResource(path);
        if (resourceURL == null) {
            EXISTS_CHECK.put(path, false);
            chain.doFilter(request, response);
        } else {
            this.serveResource(response, resourceURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveResource(ServletResponse response, URL resourceURL) throws IOException {
        String extension = resourceURL.getPath().substring(resourceURL.getPath().lastIndexOf(46) + 1);
        String ct = FILE_TYPES.get(extension);
        response.setContentType(ct);
        InputStream in = null;
        ServletOutputStream out = null;
        try {
            in = resourceURL.openStream();
            out = response.getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void destroy() {
    }

    static {
        FILE_TYPES.put("png", "image/png");
        FILE_TYPES.put("css", "text/css");
        FILE_TYPES.put("js", "text/javascript");
    }
}

