/*
 * Decompiled with CFR 0.152.
 */
package org.s_ramp.xmlns._2010.s_ramp;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Scanner;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import junit.framework.Assert;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Test;
import org.s_ramp.xmlns._2010.s_ramp.Artifact;
import org.s_ramp.xmlns._2010.s_ramp.ObjectFactory;
import org.s_ramp.xmlns._2010.s_ramp.Property;
import org.s_ramp.xmlns._2010.s_ramp.Relationship;
import org.s_ramp.xmlns._2010.s_ramp.Target;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;

public class XsdDocumentTest {
    @Test
    public void marshall() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.s_ramp.xmlns._2010.s_ramp");
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.schemaLocation", (Object)"http://s-ramp.org/xmlns/2010/s-ramp/xsdmodel.xsd");
            ObjectFactory factory = new ObjectFactory();
            Artifact artifact = factory.createArtifact();
            XsdDocument xsdDocument = new XsdDocument();
            xsdDocument.setName("accountingTypes.xsd");
            xsdDocument.setDescription("accountingTypes.xsd");
            xsdDocument.setCreatedBy("Bellwood");
            xsdDocument.setVersion("1.0");
            xsdDocument.setUuid("aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaa6a");
            XMLGregorianCalendar createdTS = DatatypeFactory.newInstance().newXMLGregorianCalendar("2009-05-26T13:13:55.013+02:00");
            xsdDocument.setCreatedTimestamp(createdTS);
            XMLGregorianCalendar lastModifiedTS = DatatypeFactory.newInstance().newXMLGregorianCalendar("2009-06-26T13:13:55.013+02:00");
            xsdDocument.setLastModifiedTimestamp(lastModifiedTS);
            xsdDocument.setLastModifiedBy("Pospisil");
            xsdDocument.setContentType("application/xml");
            xsdDocument.setContentEncoding("UTF-8");
            xsdDocument.setContentSize(Long.valueOf(4096L));
            xsdDocument.getClassifiedBy().add("http://example.org/ontologies/accounting.owl/accounts");
            Target importedXsdTarget = new Target();
            importedXsdTarget.setValue("aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaa6b");
            importedXsdTarget.getOtherAttributes().put(new QName("xlink:href"), "http://example.org/s-ramp/xsd/XsdDocument/aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaa6b");
            xsdDocument.getImportedXsds().add(importedXsdTarget);
            Relationship relationship = new Relationship();
            relationship.setRelationshipType("similarXsds");
            Target relationshipTarget = new Target();
            relationshipTarget.setValue("aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaa6b");
            relationshipTarget.getOtherAttributes().put(new QName("xlink:href"), "http://example.org/s-ramp/xsd/XsdDocument/aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaa6b");
            relationship.getRelationshipTarget().add(relationshipTarget);
            Target relationshipTarget2 = new Target();
            relationshipTarget2.setValue("aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaa6c");
            relationshipTarget2.getOtherAttributes().put(new QName("xlink:href"), "http://example.org/s-ramp/xsd/XsdDocument/aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaa6c");
            relationship.getRelationshipTarget().add(relationshipTarget2);
            xsdDocument.getRelationship().add(relationship);
            Property property = new Property();
            property.setPropertyName("myPropertyName");
            property.setPropertyValue("myPropertyValue");
            xsdDocument.getProperty().add(property);
            artifact.setXsdDocument(xsdDocument);
            StringWriter writer = new StringWriter();
            JAXBElement element = new JAXBElement(new QName("", "artifact", "s-ramp"), Artifact.class, (Object)artifact);
            marshaller.marshal((Object)element, (Writer)writer);
            String actualXml = writer.toString();
            System.out.println(actualXml);
            Assert.assertNotNull((String)"Cannot locate file XsdDocument-entry.xml", (Object)this.getClass().getResourceAsStream("XsdDocument-entry.xml"));
            String expectedXML = new Scanner(this.getClass().getResourceAsStream("XsdDocument-entry.xml")).useDelimiter("\\Z").next();
            System.out.println(expectedXML);
            Diff diff = new Diff(expectedXML, actualXml);
            boolean isSimilar = diff.similar();
            XMLAssert.assertTrue((boolean)isSimilar);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"No exception should be thrown");
        }
    }

    @Test
    public void unmarshall() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.s_ramp.xmlns._2010.s_ramp");
            Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
            Assert.assertNotNull((String)"Cannot locate file XsdDocument-entry.xml", (Object)this.getClass().getResourceAsStream("XsdDocument-entry.xml"));
            String expectedXML = new Scanner(this.getClass().getResourceAsStream("XsdDocument-entry.xml")).useDelimiter("\\Z").next();
            StringReader reader = new StringReader(expectedXML);
            JAXBElement element = unMarshaller.unmarshal((Source)new StreamSource(reader), Artifact.class);
            Artifact artifact = (Artifact)element.getValue();
            Assert.assertEquals((String)"accountingTypes.xsd", (String)artifact.getXsdDocument().getName());
        }
        catch (JAXBException jaxbe) {
            jaxbe.printStackTrace();
            Assert.fail((String)"No exception should be thrown");
        }
    }

    @Test
    public void unmarshall2() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.s_ramp.xmlns._2010.s_ramp");
            Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
            Assert.assertNotNull((String)"Cannot locate file XsdDocument-entry2.xml", (Object)this.getClass().getResourceAsStream("XsdDocument-entry2.xml"));
            String expectedXML = new Scanner(this.getClass().getResourceAsStream("XsdDocument-entry2.xml")).useDelimiter("\\Z").next();
            StringReader reader = new StringReader(expectedXML);
            JAXBElement element = unMarshaller.unmarshal((Source)new StreamSource(reader), Artifact.class);
            Artifact artifact = (Artifact)element.getValue();
            Assert.assertEquals((String)"accountingTypes.xsd", (String)artifact.getXsdDocument().getName());
        }
        catch (JAXBException jaxbe) {
            jaxbe.printStackTrace();
            Assert.fail((String)"No exception should be thrown");
        }
    }
}

