/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactEnum;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;
import test.org.overlord.sramp.atom.AtomTestUtils;

public class SrampArchiveTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSrampArchiveFile() throws Exception {
        InputStream resourceAsStream = null;
        File tempFile = null;
        FileOutputStream tempFileStream = null;
        SrampArchive archive = null;
        try {
            resourceAsStream = SrampArchiveTest.class.getResourceAsStream("simple-sramp-archive.zip");
            tempFile = File.createTempFile("sramp_test", "ar");
            tempFileStream = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)resourceAsStream, (OutputStream)tempFileStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)resourceAsStream);
            IOUtils.closeQuietly(tempFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)resourceAsStream);
        IOUtils.closeQuietly((OutputStream)tempFileStream);
        try {
            archive = new SrampArchive(tempFile);
            File workDir = AtomTestUtils.getArchiveWorkDir(archive);
            Assert.assertNotNull((Object)workDir);
            Assert.assertTrue((boolean)workDir.isDirectory());
            Collection files = FileUtils.listFiles((File)workDir, (String[])new String[]{"xsd", "atom"}, (boolean)true);
            Assert.assertEquals((long)2L, (long)files.size());
            HashSet<String> fnames = new HashSet<String>();
            for (File f : files) {
                fnames.add(f.getName());
            }
            Assert.assertTrue((boolean)fnames.contains("sample.xsd"));
            Assert.assertTrue((boolean)fnames.contains("sample.xsd.atom"));
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntries() throws Exception {
        InputStream resourceAsStream = null;
        File tempFile = null;
        FileOutputStream tempFileStream = null;
        SrampArchive archive = null;
        try {
            resourceAsStream = SrampArchiveTest.class.getResourceAsStream("simple-sramp-archive.zip");
            tempFile = File.createTempFile("sramp_test", "ar");
            tempFileStream = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)resourceAsStream, (OutputStream)tempFileStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)resourceAsStream);
            IOUtils.closeQuietly(tempFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)resourceAsStream);
        IOUtils.closeQuietly((OutputStream)tempFileStream);
        try {
            archive = new SrampArchive(tempFile);
            Collection entries = archive.getEntries();
            Assert.assertEquals((long)1L, (long)entries.size());
            SrampArchiveEntry entry = (SrampArchiveEntry)entries.iterator().next();
            Assert.assertEquals((Object)"sample.xsd", (Object)entry.getPath());
            Assert.assertNotNull((Object)entry.getMetaData());
            Assert.assertEquals((Object)"d658b181-975c-42c5-ad5c-dc65cb9aa4a1", (Object)entry.getMetaData().getUuid());
            Assert.assertEquals((Object)"sample.xsd", (Object)entry.getMetaData().getName());
            Assert.assertEquals((Object)"1.0", (Object)entry.getMetaData().getVersion());
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddEntry() throws Exception {
        InputStream artifactContentStream = SrampArchiveTest.class.getResourceAsStream("sample.xsd");
        XsdDocument artifactMetaData = new XsdDocument();
        this.setMetaData(artifactMetaData, "sample.xsd", "1.0.3", "Just a sample XML Schema.");
        SrampArchive archive = null;
        try {
            archive = new SrampArchive();
            archive.addEntry("sample.xsd", (BaseArtifactType)artifactMetaData, artifactContentStream);
            File workDir = AtomTestUtils.getArchiveWorkDir(archive);
            Assert.assertNotNull((Object)workDir);
            Assert.assertTrue((boolean)workDir.isDirectory());
            Collection files = FileUtils.listFiles((File)workDir, (String[])new String[]{"xsd", "atom"}, (boolean)true);
            Assert.assertEquals((long)2L, (long)files.size());
            HashSet<String> fnames = new HashSet<String>();
            for (File f : files) {
                fnames.add(f.getName());
            }
            Assert.assertTrue((boolean)fnames.contains("sample.xsd"));
            Assert.assertTrue((boolean)fnames.contains("sample.xsd.atom"));
        }
        finally {
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArchiveRoundtrip() throws Exception {
        SrampArchive archive = null;
        File archiveFile = null;
        try {
            InputStream artifact1ContentStream = SrampArchiveTest.class.getResourceAsStream("sample.xsd");
            InputStream artifact2ContentStream = SrampArchiveTest.class.getResourceAsStream("PO.xsd");
            InputStream artifact3ContentStream = SrampArchiveTest.class.getResourceAsStream("coremodel.xsd");
            InputStream artifact4ContentStream = SrampArchiveTest.class.getResourceAsStream("xlink.xsd");
            String path1 = "sample/sample.xsd";
            String path2 = "sample/PO.xsd";
            String path3 = "s-ramp/coremodel.xsd";
            String path4 = "s-ramp/xlink.xsd";
            XsdDocument artifact1MetaData = new XsdDocument();
            XsdDocument artifact2MetaData = new XsdDocument();
            XsdDocument artifact3MetaData = new XsdDocument();
            XsdDocument artifact4MetaData = new XsdDocument();
            this.setMetaData(artifact1MetaData, "sample.xsd", "1.0.3", "Just a sample XML Schema.");
            this.setMetaData(artifact2MetaData, "PO.xsd", "2.1.4", "The Purchase Order schema.");
            this.setMetaData(artifact3MetaData, "coremodel.xsd", "1.6.1", "S-RAMP core schema.");
            this.setMetaData(artifact4MetaData, "xlink.xsd", "1.6.1", "X-LINK schema.");
            archive = new SrampArchive();
            archive.addEntry(path1, (BaseArtifactType)artifact1MetaData, artifact1ContentStream);
            archive.addEntry(path2, (BaseArtifactType)artifact2MetaData, artifact2ContentStream);
            archive.addEntry(path3, (BaseArtifactType)artifact3MetaData, artifact3ContentStream);
            archive.addEntry(path4, (BaseArtifactType)artifact4MetaData, artifact4ContentStream);
            archiveFile = archive.pack();
        }
        catch (Throwable throwable) {
            SrampArchive.closeQuietly(archive);
            throw throwable;
        }
        SrampArchive.closeQuietly((SrampArchive)archive);
        try {
            archive = new SrampArchive(archiveFile);
            Collection entries = archive.getEntries();
            Assert.assertEquals((long)4L, (long)entries.size());
            HashMap<String, SrampArchiveEntry> entryMap = new HashMap<String, SrampArchiveEntry>();
            for (SrampArchiveEntry entry : entries) {
                entryMap.put(entry.getPath(), entry);
            }
            XsdDocument sampleXsdMetaData = (XsdDocument)((SrampArchiveEntry)entryMap.get("sample/sample.xsd")).getMetaData();
            Assert.assertNotNull((Object)sampleXsdMetaData);
            Assert.assertEquals((Object)"sample.xsd", (Object)sampleXsdMetaData.getName());
            Assert.assertEquals((Object)"1.0.3", (Object)sampleXsdMetaData.getVersion());
            Assert.assertEquals((Object)"Just a sample XML Schema.", (Object)sampleXsdMetaData.getDescription());
            XsdDocument poXsdMetaData = (XsdDocument)((SrampArchiveEntry)entryMap.get("sample/PO.xsd")).getMetaData();
            Assert.assertNotNull((Object)poXsdMetaData);
            Assert.assertEquals((Object)"PO.xsd", (Object)poXsdMetaData.getName());
            Assert.assertEquals((Object)"2.1.4", (Object)poXsdMetaData.getVersion());
            Assert.assertEquals((Object)"The Purchase Order schema.", (Object)poXsdMetaData.getDescription());
            XsdDocument coremodelXsdMetaData = (XsdDocument)((SrampArchiveEntry)entryMap.get("s-ramp/coremodel.xsd")).getMetaData();
            Assert.assertNotNull((Object)coremodelXsdMetaData);
            Assert.assertEquals((Object)"coremodel.xsd", (Object)coremodelXsdMetaData.getName());
            Assert.assertEquals((Object)"1.6.1", (Object)coremodelXsdMetaData.getVersion());
            Assert.assertEquals((Object)"S-RAMP core schema.", (Object)coremodelXsdMetaData.getDescription());
            XsdDocument xlinkXsdMetaData = (XsdDocument)((SrampArchiveEntry)entryMap.get("s-ramp/xlink.xsd")).getMetaData();
            Assert.assertNotNull((Object)xlinkXsdMetaData);
            Assert.assertEquals((Object)"xlink.xsd", (Object)xlinkXsdMetaData.getName());
            Assert.assertEquals((Object)"1.6.1", (Object)xlinkXsdMetaData.getVersion());
            Assert.assertEquals((Object)"X-LINK schema.", (Object)xlinkXsdMetaData.getDescription());
        }
        finally {
            SrampArchive.closeQuietly((SrampArchive)archive);
            FileUtils.deleteQuietly((File)archiveFile);
        }
    }

    private void setMetaData(XsdDocument artifactMetaData, String name, String version, String desc) {
        artifactMetaData.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        artifactMetaData.setName(name);
        artifactMetaData.setVersion(version);
        artifactMetaData.setDescription(desc);
    }
}

