/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.jboss.resteasy.plugins.providers.atom.Category;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Link;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampConstants;
import org.s_ramp.xmlns._2010.s_ramp.Artifact;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public final class SrampAtomUtils {
    private SrampAtomUtils() {
    }

    public static BaseArtifactType unwrapSrampArtifact(ArtifactType artifactType, Artifact artifact) {
        return artifactType.unwrap(artifact);
    }

    public static BaseArtifactType unwrapSrampArtifact(Entry entry) {
        ArtifactType artifactType = SrampAtomUtils.getArtifactType(entry);
        return SrampAtomUtils.unwrapSrampArtifact(artifactType, entry);
    }

    public static BaseArtifactType unwrapSrampArtifact(ArtifactType artifactType, Entry entry) {
        try {
            Artifact artifact = SrampAtomUtils.getArtifactWrapper(entry);
            if (artifact != null) {
                return SrampAtomUtils.unwrapSrampArtifact(artifactType, artifact);
            }
            return null;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private static Artifact getArtifactWrapper(Entry entry) throws JAXBException {
        return SrampAtomUtils.unwrap(entry, Artifact.class);
    }

    public static Entry wrapSrampArtifact(BaseArtifactType artifact) throws URISyntaxException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Entry entry = new Entry();
        if (artifact.getUuid() != null) {
            entry.setId(new URI(artifact.getUuid()));
        }
        if (artifact.getLastModifiedTimestamp() != null) {
            entry.setUpdated(artifact.getLastModifiedTimestamp().toGregorianCalendar().getTime());
        }
        if (artifact.getName() != null) {
            entry.setTitle(artifact.getName());
        }
        if (artifact.getCreatedTimestamp() != null) {
            entry.setPublished(artifact.getCreatedTimestamp().toGregorianCalendar().getTime());
        }
        if (artifact.getCreatedBy() != null) {
            entry.getAuthors().add(new Person(artifact.getCreatedBy()));
        }
        if (artifact.getDescription() != null) {
            entry.setSummary(artifact.getDescription());
        }
        Artifact srampArty = new Artifact();
        Method method = Artifact.class.getMethod("set" + artifact.getClass().getSimpleName(), artifact.getClass());
        method.invoke((Object)srampArty, artifact);
        entry.setAnyOtherJAXBObject((Object)srampArty);
        return entry;
    }

    public static ArtifactType getArtifactType(Entry entry) {
        ArtifactType type = SrampAtomUtils.getArtifactTypeFromEntry(entry);
        if (type.isExtendedType()) {
            boolean derived = "true".equals(entry.getExtensionAttributes().get(SrampConstants.SRAMP_DERIVED_QNAME));
            String extendedType = (String)entry.getExtensionAttributes().get(SrampConstants.SRAMP_EXTENDED_TYPE_QNAME);
            type.setExtendedDerivedType(derived);
            type.setExtendedType(extendedType);
        }
        return type;
    }

    protected static ArtifactType getArtifactTypeFromEntry(Entry entry) {
        List categories = entry.getCategories();
        for (Category cat : categories) {
            if (!"x-s-ramp:2010:type".equals(cat.getScheme().toString())) continue;
            String atype = cat.getTerm();
            return ArtifactType.valueOf((String)atype);
        }
        Link link = entry.getLinkByRel("self");
        if (link != null) {
            URI href = link.getHref();
            String path = href.getPath();
            String[] split = path.split("/");
            String atype = split[split.length - 2];
            return ArtifactType.valueOf((String)atype);
        }
        try {
            Artifact artifactWrapper = SrampAtomUtils.getArtifactWrapper(entry);
            if (artifactWrapper != null) {
                return ArtifactType.valueOf((Artifact)artifactWrapper);
            }
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        return ArtifactType.valueOf((String)"Document");
    }

    public static <T> T unwrap(Entry entry, Class<T> clazz) throws JAXBException {
        Object object = entry.getAnyOtherJAXBObject(clazz, new Class[0]);
        if (object == null) {
            for (Object anyOther : entry.getAnyOther()) {
                if (anyOther == null || !anyOther.getClass().equals(clazz)) continue;
                object = anyOther;
                break;
            }
        }
        return (T)object;
    }
}

