/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.archive.expand.registry;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchiveException;
import org.overlord.sramp.atom.archive.expand.registry.ZipToSrampArchiveProvider;
import org.overlord.sramp.common.ArtifactType;

public final class ZipToSrampArchiveRegistry {
    private static Map<ArtifactType, ZipToSrampArchiveProvider> providerCache = new HashMap<ArtifactType, ZipToSrampArchiveProvider>();
    private static List<ZipToSrampArchiveProvider> providers = new ArrayList<ZipToSrampArchiveProvider>();

    private static void discoverProviders() {
        for (ZipToSrampArchiveProvider provider : ServiceLoader.load(ZipToSrampArchiveProvider.class)) {
            providers.add(provider);
        }
    }

    public static ZipToSrampArchive createExpander(ArtifactType artifactType, InputStream zipStream) throws ZipToSrampArchiveException {
        ZipToSrampArchiveProvider provider = ZipToSrampArchiveRegistry.getProvider(artifactType);
        if (provider == null) {
            return null;
        }
        return provider.createExtractor(artifactType, zipStream);
    }

    public static ZipToSrampArchive createExpander(ArtifactType artifactType, File zipFile) throws ZipToSrampArchiveException {
        ZipToSrampArchiveProvider provider = ZipToSrampArchiveRegistry.getProvider(artifactType);
        if (provider == null) {
            return null;
        }
        return provider.createExtractor(artifactType, zipFile);
    }

    public static boolean canExpand(ArtifactType artifactType) throws ZipToSrampArchiveException {
        ZipToSrampArchiveProvider provider = ZipToSrampArchiveRegistry.getProvider(artifactType);
        return provider != null;
    }

    protected static ZipToSrampArchiveProvider getProvider(ArtifactType artifactType) {
        ZipToSrampArchiveProvider provider = null;
        if (providerCache.containsKey(artifactType)) {
            provider = providerCache.get(artifactType);
        } else {
            provider = null;
            for (ZipToSrampArchiveProvider p : providers) {
                if (!p.accept(artifactType)) continue;
                provider = p;
                break;
            }
            providerCache.put(artifactType, provider);
        }
        return provider;
    }

    static {
        ZipToSrampArchiveRegistry.discoverProviders();
    }
}

