/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.client;

import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.i18n.Messages;
import org.overlord.sramp.atom.providers.HttpResponseProvider;
import org.overlord.sramp.atom.providers.SrampAtomExceptionProvider;

public class ClientRequest
extends org.jboss.resteasy.client.ClientRequest {
    private static final ResteasyProviderFactory providerFactory = new ResteasyProviderFactory();

    private static UriBuilder getBuilder(String uriTemplate) {
        return new UriBuilderImpl().uriTemplate(uriTemplate);
    }

    public ClientRequest(String uriTemplate) {
        super(ClientRequest.getBuilder(uriTemplate), ClientRequest.getDefaultExecutor(), providerFactory);
    }

    public ClientRequest(String uriTemplate, ClientExecutor clientExecutor) {
        super(ClientRequest.getBuilder(uriTemplate), clientExecutor, providerFactory);
    }

    public <T> ClientResponse<T> post(Class<T> returnType) throws Exception {
        ClientResponse response = super.post(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public ClientResponse post() throws Exception {
        ClientResponse response = super.post();
        this.handlePotentialServerError(response);
        return response;
    }

    public <T> ClientResponse<T> get(Class<T> returnType) throws Exception {
        ClientResponse response = super.get(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public ClientResponse get() throws Exception {
        ClientResponse response = super.get();
        this.handlePotentialServerError(response);
        return response;
    }

    public <T> ClientResponse<T> put(Class<T> returnType) throws Exception {
        ClientResponse response = super.put(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public ClientResponse put() throws Exception {
        ClientResponse response = super.put();
        this.handlePotentialServerError(response);
        return response;
    }

    public <T> ClientResponse<T> delete(Class<T> returnType) throws Exception {
        ClientResponse response = super.delete(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public ClientResponse delete() throws Exception {
        ClientResponse response = super.delete();
        this.handlePotentialServerError(response);
        return response;
    }

    private <T> void handlePotentialServerError(ClientResponse<T> response) throws Exception {
        String contentType = String.valueOf(response.getMetadata().getFirst((Object)"Content-Type"));
        if (response.getStatus() == 500) {
            Exception error = new Exception(Messages.i18n.format("UNKNOWN_SRAMP_ERROR", new Object[0]));
            if ("application/sramp-atom-exception".equals(contentType)) {
                try {
                    SrampAtomException entity = (SrampAtomException)response.getEntity(SrampAtomException.class);
                    if (entity != null) {
                        error = entity;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            throw error;
        }
        if (response.getStatus() == 404 || response.getStatus() == 415) {
            SrampAtomException error = new SrampAtomException(Messages.i18n.format("ENDPOINT_NOT_FOUND", new Object[0]));
            throw error;
        }
        if (response.getStatus() == 403) {
            SrampAtomException error = new SrampAtomException(Messages.i18n.format("AUTHORIZATION_FAILED", new Object[0]));
            throw error;
        }
        if (response.getStatus() == 401) {
            SrampAtomException error = new SrampAtomException(Messages.i18n.format("AUTHENTICATION_FAILED", new Object[0]));
            throw error;
        }
    }

    static {
        RegisterBuiltin.register((ResteasyProviderFactory)providerFactory);
        providerFactory.registerProvider(SrampAtomExceptionProvider.class);
        providerFactory.registerProvider(HttpResponseProvider.class);
    }
}

