/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.atom.i18n.Messages;

public class ArchiveUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackToWorkDir(File archiveFile, File toDir) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            Enumeration zipEntries = zipFile.getEntriesInPhysicalOrder();
            while (zipEntries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
                String entryName = entry.getName();
                File outFile = new File(toDir, entryName);
                if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                    throw new IOException(Messages.i18n.format("FAILED_TO_CREATE_PARENT_DIR", new Object[]{outFile.getParentFile().getCanonicalPath()}));
                }
                if (entry.isDirectory()) {
                    if (outFile.mkdir()) continue;
                    throw new IOException(Messages.i18n.format("FAILED_TO_CREATE_DIR", new Object[]{outFile.getCanonicalPath()}));
                }
                InputStream zipStream = null;
                FileOutputStream outFileStream = null;
                zipStream = zipFile.getInputStream(entry);
                outFileStream = new FileOutputStream(outFile);
                try {
                    IOUtils.copy((InputStream)zipStream, (OutputStream)outFileStream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)zipStream);
                    IOUtils.closeQuietly((OutputStream)outFileStream);
                }
            }
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zipFile);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zipFile);
    }
}

