/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.archive.expand;

import java.util.UUID;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Document;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.atom.archive.expand.DiscoveredArtifact;
import org.overlord.sramp.atom.archive.expand.MetaDataFactory;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchiveContext;
import org.overlord.sramp.common.SrampModelUtils;

public class DefaultMetaDataFactory
implements MetaDataFactory {
    public static final String PARENT_UUID = "parent.uuid";
    private ZipToSrampArchiveContext context;

    @Override
    public void setContext(ZipToSrampArchiveContext context) {
        this.context = context;
    }

    @Override
    public BaseArtifactType createMetaData(DiscoveredArtifact discoveredArtifact) {
        BaseArtifactType artifact = this.createArtifact(discoveredArtifact);
        this.addStandardMetaData(discoveredArtifact, artifact);
        return artifact;
    }

    protected void addStandardMetaData(DiscoveredArtifact discoveredArtifact, BaseArtifactType artifact) {
        String parentUUID;
        artifact.setUuid(UUID.randomUUID().toString());
        artifact.setName(discoveredArtifact.getName());
        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"batch.archive-path", (String)discoveredArtifact.getArchivePath());
        if (this.context != null && (parentUUID = (String)this.context.get(PARENT_UUID)) != null) {
            SrampModelUtils.addGenericRelationship((BaseArtifactType)artifact, (String)"expandedFromDocument", (String)parentUUID);
        }
    }

    protected BaseArtifactType createArtifact(DiscoveredArtifact discoveredArtifact) {
        XmlDocument metaData = null;
        String archivePath = discoveredArtifact.getArchivePath().toLowerCase();
        if (archivePath.endsWith(".xml")) {
            metaData = new XmlDocument();
            metaData.setArtifactType(BaseArtifactEnum.XML_DOCUMENT);
        } else if (archivePath.endsWith(".wsdl")) {
            metaData = new WsdlDocument();
            metaData.setArtifactType(BaseArtifactEnum.WSDL_DOCUMENT);
        } else if (archivePath.endsWith(".xsd")) {
            metaData = new XsdDocument();
            metaData.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        } else if (archivePath.endsWith(".wspolicy")) {
            metaData = new XsdDocument();
            metaData.setArtifactType(BaseArtifactEnum.POLICY_DOCUMENT);
        } else {
            metaData = new Document();
            metaData.setArtifactType(BaseArtifactEnum.DOCUMENT);
        }
        return metaData;
    }
}

