/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.visitors;

import java.util.List;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Actor;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Binding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Element;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Fault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Operation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Organization;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Part;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Policy;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Port;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Service;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContract;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceEndpoint;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstance;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterface;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoaModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlService;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.atom.visitors.ArtifactToSummaryAtomEntryVisitor;

public class ArtifactToFullAtomEntryVisitor
extends ArtifactToSummaryAtomEntryVisitor {
    public ArtifactToFullAtomEntryVisitor(String baseUrl) {
        super(baseUrl);
    }

    @Override
    protected void visitBase(BaseArtifactType artifact) {
        for (Relationship relationship : artifact.getRelationship()) {
            for (Target target : relationship.getRelationshipTarget()) {
                this.setTargetHref(target);
            }
        }
        super.visitBase(artifact);
    }

    protected void visitDerived(DerivedArtifactType artifact) {
        this.setTargetHref((Target)artifact.getRelatedDocument());
        super.visitDerived(artifact);
    }

    protected void visitWsdlDerived(WsdlDerivedArtifactType artifact) {
        this.setTargetHref(artifact.getExtension());
        super.visitWsdlDerived(artifact);
    }

    protected void visitServiceImplementation(ServiceImplementationModelType artifact) {
        this.setTargetHref(artifact.getDocumentation());
        super.visitServiceImplementation(artifact);
    }

    protected void visitSoa(SoaModelType artifact) {
        this.setTargetHref(artifact.getDocumentation());
        super.visitSoa(artifact);
    }

    protected void visitElement(Element artifact) {
        this.setTargetHref(artifact.getRepresents());
        this.setTargetHref(artifact.getUses());
        this.setTargetHref(artifact.getPerforms());
        this.setTargetHref((Target)artifact.getDirectsOrchestration());
        this.setTargetHref((Target)artifact.getDirectsOrchestrationProcess());
        this.setTargetHref(artifact.getGenerates());
        this.setTargetHref(artifact.getRespondsTo());
        super.visitElement(artifact);
    }

    protected void visitActor(Actor artifact) {
        this.setTargetHref(artifact.getDoes());
        this.setTargetHref(artifact.getSetsPolicy());
        super.visitActor(artifact);
    }

    public void visit(XsdDocument artifact) {
        this.setTargetHref(artifact.getImportedXsds());
        this.setTargetHref(artifact.getIncludedXsds());
        this.setTargetHref(artifact.getRedefinedXsds());
        super.visit(artifact);
    }

    public void visit(WsdlDocument artifact) {
        this.setTargetHref(artifact.getImportedXsds());
        this.setTargetHref(artifact.getIncludedXsds());
        this.setTargetHref(artifact.getRedefinedXsds());
        this.setTargetHref(artifact.getImportedWsdls());
        super.visit(artifact);
    }

    public void visit(Message artifact) {
        this.setTargetHref(artifact.getPart());
        super.visit(artifact);
    }

    public void visit(Part artifact) {
        this.setTargetHref((Target)artifact.getElement());
        this.setTargetHref((Target)artifact.getType());
        super.visit(artifact);
    }

    public void visit(PortType artifact) {
        this.setTargetHref(artifact.getOperation());
        super.visit(artifact);
    }

    public void visit(Operation artifact) {
        this.setTargetHref((Target)artifact.getInput());
        this.setTargetHref((Target)artifact.getOutput());
        this.setTargetHref(artifact.getFault());
        super.visit(artifact);
    }

    public void visit(OperationInput artifact) {
        this.setTargetHref((Target)artifact.getMessage());
        super.visit(artifact);
    }

    public void visit(OperationOutput artifact) {
        this.setTargetHref((Target)artifact.getMessage());
        super.visit(artifact);
    }

    public void visit(Fault artifact) {
        this.setTargetHref((Target)artifact.getMessage());
        super.visit(artifact);
    }

    public void visit(Binding artifact) {
        this.setTargetHref(artifact.getBindingOperation());
        this.setTargetHref((Target)artifact.getPortType());
        super.visit(artifact);
    }

    public void visit(BindingOperation artifact) {
        this.setTargetHref((Target)artifact.getInput());
        this.setTargetHref((Target)artifact.getOutput());
        this.setTargetHref(artifact.getFault());
        this.setTargetHref((Target)artifact.getOperation());
        super.visit(artifact);
    }

    public void visit(WsdlService artifact) {
        this.setTargetHref(artifact.getPort());
        super.visit(artifact);
    }

    public void visit(Port artifact) {
        this.setTargetHref((Target)artifact.getBinding());
        super.visit(artifact);
    }

    public void visit(ServiceEndpoint artifact) {
        this.setTargetHref((Target)artifact.getEndpointDefinedBy());
        super.visit(artifact);
    }

    public void visit(ServiceInstance artifact) {
        this.setTargetHref(artifact.getDescribedBy());
        this.setTargetHref(artifact.getUses());
        super.visit(artifact);
    }

    public void visit(ServiceOperation artifact) {
        this.setTargetHref((Target)artifact.getOperationDefinedBy());
        super.visit(artifact);
    }

    public void visit(Policy artifact) {
        this.setTargetHref(artifact.getAppliesTo());
        super.visit(artifact);
    }

    public void visit(ServiceInterface artifact) {
        this.setTargetHref((Target)artifact.getHasOperation());
        this.setTargetHref(artifact.getHasOutput());
        this.setTargetHref(artifact.getHasInput());
        this.setTargetHref(artifact.getIsInterfaceOf());
        super.visit(artifact);
    }

    public void visit(ServiceContract artifact) {
        this.setTargetHref(artifact.getInvolvesParty());
        this.setTargetHref(artifact.getSpecifies());
        super.visit(artifact);
    }

    public void visit(Organization artifact) {
        this.setTargetHref(artifact.getProvides());
        super.visit(artifact);
    }

    public void visit(Service artifact) {
        this.setTargetHref(artifact.getHasContract());
        this.setTargetHref(artifact.getHasInterface());
        this.setTargetHref((Target)artifact.getHasInstance());
        super.visit(artifact);
    }

    private void setTargetHref(List<? extends Target> targets) {
        for (Target target : targets) {
            this.setTargetHref(target);
        }
    }

    private void setTargetHref(Target target) {
        if (target != null) {
            target.setHref(this.baseUrl + "/s-ramp/" + target.getHref());
        }
    }

    @Override
    protected boolean includeArtifact() {
        return true;
    }

    @Override
    protected BaseArtifactType createIncludedArtifact(BaseArtifactType artifact) throws InstantiationException, IllegalAccessException {
        return artifact;
    }
}

