/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Category;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.app.AppCategories;
import org.jboss.resteasy.plugins.providers.atom.app.AppCollection;
import org.jboss.resteasy.plugins.providers.atom.app.AppService;
import org.jboss.resteasy.plugins.providers.atom.app.AppWorkspace;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.beans.HttpResponseBean;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.SrampClientQuery;
import org.overlord.sramp.client.ontology.OntologySummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.MimeTypes;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;

public class SrampAtomApiClient {
    private String endpoint;
    private boolean validating;
    private Set<String> enabledFeatures = new HashSet<String>();

    public SrampAtomApiClient(String endpoint) {
        this.endpoint = endpoint;
        if (this.endpoint.endsWith("/")) {
            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 1);
        }
        if (!this.endpoint.endsWith("/s-ramp")) {
            this.endpoint = this.endpoint + "/s-ramp";
        }
    }

    public SrampAtomApiClient(String endpoint, boolean validating) throws SrampClientException, SrampAtomException {
        this(endpoint);
        this.validating = validating;
        if (this.validating) {
            this.discoverAvailableFeatures();
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    private void discoverAvailableFeatures() throws SrampClientException, SrampAtomException {
        AppService serviceDoc = this.getServiceDocument();
        for (AppWorkspace workspace : serviceDoc.getWorkspace()) {
            for (AppCollection collection : workspace.getCollection()) {
                for (AppCategories cats : collection.getCategories()) {
                    for (Category category : cats.getCategory()) {
                        this.enabledFeatures.add(category.getTerm());
                    }
                }
            }
        }
    }

    private void assertFeatureEnabled(String feature) throws SrampClientException {
        if (this.validating && !this.enabledFeatures.contains(feature)) {
            throw new SrampClientException("The S-RAMP repository does not appear to support this feature.");
        }
    }

    private void assertFeatureEnabled(ArtifactType feature) throws SrampClientException {
        if (this.validating && !this.enabledFeatures.contains(feature.getArtifactType().getType())) {
            throw new SrampClientException("The S-RAMP repository does not appear to support this feature.");
        }
    }

    public AppService getServiceDocument() throws SrampClientException, SrampAtomException {
        try {
            String atomUrl = String.format("%1$s/servicedocument", this.endpoint);
            ClientRequest request = new ClientRequest(atomUrl);
            ClientResponse response = request.get(AppService.class);
            return (AppService)response.getEntity();
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public BaseArtifactType getArtifactMetaData(ArtifactType artifactType, String artifactUuid) throws SrampClientException, SrampAtomException {
        this.assertFeatureEnabled(artifactType);
        try {
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s", this.endpoint, artifactType.getArtifactType().getModel(), artifactType.getArtifactType().getType(), artifactUuid);
            ClientRequest request = new ClientRequest(atomUrl);
            ClientResponse response = request.get(Entry.class);
            Entry entry = (Entry)response.getEntity();
            return SrampAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)entry);
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public InputStream getArtifactContent(ArtifactType artifactType, String artifactUuid) throws SrampClientException, SrampAtomException {
        this.assertFeatureEnabled(artifactType);
        try {
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s/media", this.endpoint, artifactType.getArtifactType().getModel(), artifactType.getArtifactType().getType(), artifactUuid);
            URL url = new URL(atomUrl);
            return url.openStream();
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public BaseArtifactType uploadArtifact(ArtifactType artifactType, InputStream content, String artifactFileName) throws SrampClientException, SrampAtomException {
        this.assertFeatureEnabled(artifactType);
        String mimeType = artifactType.getMimeType();
        if (mimeType == null) {
            mimeType = MimeTypes.getContentType((String)artifactFileName);
        }
        try {
            String type = artifactType.getArtifactType().getType();
            if ("ext".equals(artifactType.getArtifactType().getModel()) && artifactType.getExtendedType() != null) {
                type = artifactType.getExtendedType();
            }
            String atomUrl = String.format("%1$s/%2$s/%3$s", this.endpoint, artifactType.getArtifactType().getModel(), type);
            ClientRequest request = new ClientRequest(atomUrl);
            if (artifactFileName != null) {
                request.header("Slug", (Object)artifactFileName);
            }
            if (mimeType != null) {
                request.header("Content-Type", (Object)mimeType);
            }
            request.body(artifactType.getMimeType(), (Object)content);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            return SrampAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)entry);
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public BaseArtifactType uploadArtifact(BaseArtifactType baseArtifactType, InputStream content) throws SrampClientException, SrampAtomException {
        ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)baseArtifactType);
        this.assertFeatureEnabled(artifactType);
        String artifactFileName = baseArtifactType.getName();
        String mimeType = artifactType.getMimeType();
        if (mimeType == null) {
            mimeType = MimeTypes.getContentType((String)artifactFileName);
            artifactType.setMimeType(mimeType);
        }
        try {
            String type = artifactType.getArtifactType().getType();
            if ("ext".equals(artifactType.getArtifactType().getModel()) && artifactType.getExtendedType() != null) {
                type = artifactType.getExtendedType();
            }
            String atomUrl = String.format("%1$s/%2$s/%3$s", this.endpoint, artifactType.getArtifactType().getModel(), type);
            ClientRequest request = new ClientRequest(atomUrl);
            MultipartRelatedOutput output = new MultipartRelatedOutput();
            Entry atomEntry = SrampAtomUtils.wrapSrampArtifact((BaseArtifactType)baseArtifactType);
            MediaType mediaType = new MediaType("application", "atom+xml");
            output.addPart((Object)atomEntry, (javax.ws.rs.core.MediaType)mediaType);
            request.body(artifactType.getMimeType(), (Object)content);
            MediaType mediaType2 = MediaType.getInstance((String)artifactType.getMimeType());
            output.addPart((Object)content, (javax.ws.rs.core.MediaType)mediaType2);
            request.body("multipart/related", (Object)output);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            return SrampAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)entry);
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, ?> uploadBatch(SrampArchive archive) throws SrampClientException, SrampAtomException {
        HashMap<String, Object> hashMap;
        File packageFile = null;
        FileInputStream packageStream = null;
        try {
            packageFile = archive.pack();
            packageStream = FileUtils.openInputStream((File)packageFile);
            ClientRequest request = new ClientRequest(this.endpoint);
            request.header("Content-Type", (Object)"application/zip");
            request.body("application/zip", (Object)packageStream);
            ClientResponse clientResponse = request.post(MultipartInput.class);
            MultipartInput response = (MultipartInput)clientResponse.getEntity();
            List parts = response.getParts();
            HashMap<String, Object> rval = new HashMap<String, Object>(parts.size());
            for (InputPart part : parts) {
                SrampAtomException exception;
                String contentId = (String)part.getHeaders().getFirst((Object)"Content-ID");
                String path = contentId.substring(1, contentId.lastIndexOf(64));
                HttpResponseBean rbean = (HttpResponseBean)part.getBody(HttpResponseBean.class, null);
                if (rbean.getCode() == 201) {
                    Entry entry = (Entry)rbean.getBody();
                    BaseArtifactType artifact = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
                    rval.put(path, artifact);
                    continue;
                }
                if (rbean.getCode() == 409) {
                    if ("application/sramp-atom-exception".equals(rbean.getHeaders().get("Content-Type"))) {
                        exception = (SrampAtomException)((Object)rbean.getBody());
                        rval.put(path, (Object)exception);
                        continue;
                    }
                    String errorReason = (String)rbean.getBody();
                    SrampAtomException exception2 = new SrampAtomException(errorReason);
                    rval.put(path, (Object)exception2);
                    continue;
                }
                exception = new SrampAtomException("Unexpected return code '" + rbean.getCode() + "' for ID '" + contentId + "'.  The S-RAMP server is non-compliant.");
                rval.put(path, (Object)exception);
            }
            hashMap = rval;
        }
        catch (SrampAtomException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new SrampClientException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(packageStream);
                FileUtils.deleteQuietly((File)packageFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)packageStream);
        FileUtils.deleteQuietly((File)packageFile);
        return hashMap;
    }

    public void updateArtifactMetaData(BaseArtifactType artifact) throws SrampClientException, SrampAtomException {
        ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
        this.assertFeatureEnabled(type);
        try {
            String artifactModel = type.getArtifactType().getModel();
            String artifactType = type.getArtifactType().getType();
            if ("ext".equals(type.getArtifactType().getModel()) && type.getExtendedType() != null) {
                artifactType = type.getExtendedType();
            }
            String artifactUuid = artifact.getUuid();
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s", this.endpoint, artifactModel, artifactType, artifactUuid);
            ClientRequest request = new ClientRequest(atomUrl);
            Entry entry = SrampAtomUtils.wrapSrampArtifact((BaseArtifactType)artifact);
            request.body("application/atom+xml;type=entry", (Object)entry);
            request.put();
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public void updateArtifactContent(BaseArtifactType artifact, InputStream content) throws SrampClientException, SrampAtomException {
        ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
        this.assertFeatureEnabled(type);
        try {
            String artifactModel = type.getArtifactType().getModel();
            String artifactType = type.getArtifactType().getType();
            if ("ext".equals(type.getArtifactType().getModel()) && type.getExtendedType() != null) {
                artifactType = type.getExtendedType();
            }
            String artifactUuid = artifact.getUuid();
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s/media", this.endpoint, artifactModel, artifactType, artifactUuid);
            ClientRequest request = new ClientRequest(atomUrl);
            request.body(type.getMimeType(), (Object)content);
            request.put();
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public void deleteArtifact(String uuid, ArtifactType type) throws SrampClientException, SrampAtomException {
        this.assertFeatureEnabled(type);
        try {
            String artifactModel = type.getArtifactType().getModel();
            String artifactType = type.getArtifactType().getType();
            if ("ext".equals(type.getArtifactType().getModel()) && type.getExtendedType() != null) {
                artifactType = type.getExtendedType();
            }
            String artifactUuid = uuid;
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s", this.endpoint, artifactModel, artifactType, artifactUuid);
            ClientRequest request = new ClientRequest(atomUrl);
            request.delete();
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public QueryResultSet query(String srampQuery) throws SrampClientException, SrampAtomException {
        return this.query(srampQuery, 0, 20, "name", true);
    }

    public QueryResultSet query(String srampQuery, int startIndex, int count, String orderBy, boolean ascending) throws SrampClientException, SrampAtomException {
        return this.query(srampQuery, startIndex, count, orderBy, ascending, null);
    }

    public QueryResultSet query(String srampQuery, int startIndex, int count, String orderBy, boolean ascending, Collection<String> propertyNames) throws SrampClientException, SrampAtomException {
        try {
            String xpath = srampQuery;
            if (xpath == null) {
                throw new Exception("Please supply an S-RAMP x-path formatted query.");
            }
            if (xpath.startsWith("/s-ramp/")) {
                xpath = xpath.substring(8);
            }
            String atomUrl = this.endpoint;
            if (propertyNames == null || propertyNames.size() < 2) {
                ClientRequest request = new ClientRequest(atomUrl);
                MultipartFormDataOutput formData = new MultipartFormDataOutput();
                formData.addFormData("query", (Object)xpath, MediaType.TEXT_PLAIN_TYPE);
                formData.addFormData("startIndex", (Object)String.valueOf(startIndex), MediaType.TEXT_PLAIN_TYPE);
                formData.addFormData("count", (Object)String.valueOf(count), MediaType.TEXT_PLAIN_TYPE);
                formData.addFormData("orderBy", (Object)orderBy, MediaType.TEXT_PLAIN_TYPE);
                formData.addFormData("ascending", (Object)String.valueOf(ascending), MediaType.TEXT_PLAIN_TYPE);
                if (propertyNames != null) {
                    for (String propertyName : propertyNames) {
                        formData.addFormData("propertyName", (Object)propertyName, MediaType.TEXT_PLAIN_TYPE);
                    }
                }
                request.body(MediaType.MULTIPART_FORM_DATA_TYPE, (Object)formData);
                ClientResponse response = request.post(Feed.class);
                return new QueryResultSet((Feed)response.getEntity());
            }
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(atomUrl);
            urlBuilder.append("?query=");
            urlBuilder.append(URLEncoder.encode(srampQuery, "UTF8"));
            urlBuilder.append("&startIndex=");
            urlBuilder.append(String.valueOf(startIndex));
            urlBuilder.append("&count=");
            urlBuilder.append(String.valueOf(count));
            urlBuilder.append("&orderBy=");
            urlBuilder.append(URLEncoder.encode(orderBy, "UTF8"));
            urlBuilder.append("&ascending=");
            urlBuilder.append(String.valueOf(ascending));
            for (String propName : propertyNames) {
                urlBuilder.append("&propertyName=");
                urlBuilder.append(URLEncoder.encode(propName, "UTF8"));
            }
            ClientRequest request = new ClientRequest(urlBuilder.toString());
            ClientResponse response = request.get(Feed.class);
            return new QueryResultSet((Feed)response.getEntity());
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public SrampClientQuery buildQuery(String query) {
        return new SrampClientQuery(this, query);
    }

    public RDF uploadOntology(InputStream content) throws SrampClientException, SrampAtomException {
        this.assertFeatureEnabled("ontology");
        try {
            String atomUrl = String.format("%1$s/ontology", this.endpoint);
            ClientRequest request = new ClientRequest(atomUrl);
            request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_RDF_XML_TYPE, (Object)content);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            RDF rdf = (RDF)SrampAtomUtils.unwrap((Entry)entry, RDF.class);
            return rdf;
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public List<OntologySummary> getOntologies() throws SrampClientException, SrampAtomException {
        this.assertFeatureEnabled("ontology");
        try {
            String atomUrl = String.format("%1$s/ontology", this.endpoint);
            ClientRequest request = new ClientRequest(atomUrl);
            ClientResponse response = request.get(Feed.class);
            Feed feed = (Feed)response.getEntity();
            ArrayList<OntologySummary> rval = new ArrayList<OntologySummary>(feed.getEntries().size());
            for (Entry entry : feed.getEntries()) {
                OntologySummary summary = new OntologySummary(entry);
                rval.add(summary);
            }
            return rval;
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }

    public void deleteOntology(String ontologyUuid) throws SrampClientException, SrampAtomException {
        this.assertFeatureEnabled("ontology");
        try {
            String atomUrl = String.format("%1$s/ontology/%2$s", this.endpoint, ontologyUuid);
            ClientRequest request = new ClientRequest(atomUrl);
            request.delete();
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampClientException(e);
        }
    }
}

