/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.test.BaseResourceTest;
import org.jboss.resteasy.test.TestPortProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.providers.HttpResponseProvider;
import org.overlord.sramp.atom.providers.SrampAtomExceptionProvider;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.jcr.JCRRepositoryFactory;
import org.overlord.sramp.server.atom.services.ArtifactResource;
import org.overlord.sramp.server.atom.services.BatchResource;
import org.overlord.sramp.server.atom.services.FeedResource;
import org.overlord.sramp.server.atom.services.QueryResource;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.XmlDocument;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;

public class SrampAtomApiClientTest
extends BaseResourceTest {
    @BeforeClass
    public static void setUp() throws Exception {
        System.setProperty("sramp.modeshape.config.url", "classpath://" + JCRRepositoryFactory.class.getName() + "/META-INF/modeshape-configs/inmemory-sramp-config.json");
        deployment.getProviderFactory().registerProvider(SrampAtomExceptionProvider.class);
        deployment.getProviderFactory().registerProvider(HttpResponseProvider.class);
        dispatcher.getRegistry().addPerRequestResource(ArtifactResource.class);
        dispatcher.getRegistry().addPerRequestResource(FeedResource.class);
        dispatcher.getRegistry().addPerRequestResource(BatchResource.class);
        dispatcher.getRegistry().addPerRequestResource(QueryResource.class);
    }

    @AfterClass
    public static void cleanup() {
        PersistenceFactory.newInstance().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadArtifact() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)artifact);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)artifact.getName());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetArtifactMetaData() throws Exception {
        SrampAtomApiClient client;
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)artifact);
            uuid = artifact.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        BaseArtifactType metaData = client.getArtifactMetaData(ArtifactType.XsdDocument(), uuid);
        junit.framework.Assert.assertNotNull((Object)metaData);
        junit.framework.Assert.assertEquals((String)artifactFileName, (String)metaData.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetArtifactMetaDataNoType() throws Exception {
        SrampAtomApiClient client;
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)artifact);
            uuid = artifact.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        BaseArtifactType metaData = client.getArtifactMetaData(uuid);
        junit.framework.Assert.assertNotNull((Object)metaData);
        junit.framework.Assert.assertEquals((String)artifactFileName, (String)metaData.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadArtifactAndContent() throws Exception {
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
            XsdDocument xsdDocument = new XsdDocument();
            xsdDocument.setName(artifactFileName);
            xsdDocument.setUuid("my-client-side-supplied-UUID");
            BaseArtifactType artifact = client.uploadArtifact((BaseArtifactType)xsdDocument, is);
            junit.framework.Assert.assertNotNull((Object)artifact);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)artifact.getName());
            junit.framework.Assert.assertEquals((String)"my-client-side-supplied-UUID", (String)artifact.getUuid());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetArtifactContent() throws Exception {
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)artifact);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)artifact.getName());
            uuid = artifact.getUuid();
        }
        finally {
            is.close();
        }
        InputStream content = client.getArtifactContent(ArtifactType.XsdDocument(), uuid.toString());
        try {
            junit.framework.Assert.assertNotNull((Object)content);
            BufferedReader reader = new BufferedReader(new InputStreamReader(content));
            String line1 = reader.readLine();
            String line2 = reader.readLine();
            junit.framework.Assert.assertTrue((String)"Unexpected content found.", (boolean)line1.startsWith("<?xml version=\"1.0\""));
            junit.framework.Assert.assertTrue((String)"Unexpected content found.", (boolean)line2.startsWith("<xsd:schema"));
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateArtifactMetaData() throws Exception {
        BaseArtifactType artifact;
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        String uuid = null;
        XsdDocument xsdDoc = null;
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)artifact);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)artifact.getName());
            uuid = artifact.getUuid();
            xsdDoc = (XsdDocument)artifact;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        xsdDoc.setDescription("** DESCRIPTION UPDATED **");
        client.updateArtifactMetaData((BaseArtifactType)xsdDoc);
        artifact = client.getArtifactMetaData(ArtifactType.XsdDocument(), uuid.toString());
        junit.framework.Assert.assertEquals((String)"** DESCRIPTION UPDATED **", (String)artifact.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateArtifactContent() throws Exception {
        BaseArtifactType artifact;
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        String uuid = null;
        XsdDocument xsdDoc = null;
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)artifact);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)artifact.getName());
            uuid = artifact.getUuid();
            xsdDoc = (XsdDocument)artifact;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/PO-updated.xsd");
        try {
            client.updateArtifactContent((BaseArtifactType)xsdDoc, is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        artifact = client.getArtifactMetaData(ArtifactType.XsdDocument(), uuid.toString());
        xsdDoc = (XsdDocument)artifact;
        junit.framework.Assert.assertEquals((Object)new Long(2583L), (Object)xsdDoc.getContentSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuery() throws Exception {
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)artifact);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)artifact.getName());
            uuid = artifact.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        QueryResultSet rset = client.query("/s-ramp/xsd/XsdDocument", 0, 50, "name", false);
        boolean uuidFound = false;
        for (ArtifactSummary entry : rset) {
            if (!entry.getUuid().equals(uuid)) continue;
            uuidFound = true;
        }
        junit.framework.Assert.assertTrue((String)"Failed to find the artifact we just added!", (boolean)uuidFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWithPropertyName() throws Exception {
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)artifact);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)artifact.getName());
            uuid = artifact.getUuid();
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"prop1", (String)"foo");
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"prop2", (String)"bar");
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"prop3", (String)"baz");
            client.updateArtifactMetaData(artifact);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        HashSet<String> propertyNames = new HashSet<String>();
        propertyNames.add("prop1");
        propertyNames.add("prop2");
        QueryResultSet rset = client.query("/s-ramp/xsd/XsdDocument[@uuid='" + uuid + "']", 0, 50, "name", false, propertyNames);
        junit.framework.Assert.assertEquals((String)"Expected a single artifact returned.", (long)1L, (long)rset.size());
        ArtifactSummary summary = rset.get(0);
        junit.framework.Assert.assertEquals((String)"foo", (String)summary.getCustomPropertyValue("prop1"));
        junit.framework.Assert.assertEquals((String)"bar", (String)summary.getCustomPropertyValue("prop2"));
        junit.framework.Assert.assertNull((String)"I didn't ask for 'prop3' to be returned!", (Object)summary.getCustomPropertyValue("prop3"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildQuery() throws Exception {
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        String uuid = null;
        String artifactFileName = "PO.xsd";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            BaseArtifactType artifact = client.uploadArtifact(ArtifactType.XsdDocument(), is, artifactFileName);
            junit.framework.Assert.assertNotNull((Object)artifact);
            junit.framework.Assert.assertEquals((String)artifactFileName, (String)artifact.getName());
            uuid = artifact.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        QueryResultSet rset = client.buildQuery("/s-ramp/xsd/XsdDocument[@uuid = ?]").parameter(uuid).count(1).query();
        junit.framework.Assert.assertTrue((String)"Failed to find the artifact we just added!", (rset.size() == 1L ? 1 : 0) != 0);
        rset = client.buildQuery("/s-ramp[@lastModifiedTimestamp < ?]").parameter(new Date(System.currentTimeMillis() + 86400000L)).count(1).query();
        junit.framework.Assert.assertTrue((String)"Failed to find an artifact by lastModifiedTimestamp!", (rset.size() == 1L ? 1 : 0) != 0);
        rset = client.buildQuery("/s-ramp[@lastModifiedTimestamp > ?]").parameter(new Date(System.currentTimeMillis() + 86400000L)).count(1).query();
        junit.framework.Assert.assertTrue((String)"Found an artifact by lastModifiedTimestamp, but should *not* have!", (rset.size() == 0L ? 1 : 0) != 0);
        Calendar endOfToday = Calendar.getInstance();
        endOfToday.set(11, 0);
        endOfToday.set(12, 0);
        endOfToday.set(13, 0);
        endOfToday.set(14, 0);
        endOfToday.add(6, 1);
        rset = client.buildQuery("/s-ramp[@lastModifiedTimestamp < ?]").parameter(endOfToday).count(1).query();
        junit.framework.Assert.assertTrue((String)"Failed to find an artifact by lastModifiedTimestamp!", (rset.size() == 1L ? 1 : 0) != 0);
        rset = client.buildQuery("/s-ramp[@lastModifiedTimestamp > ?]").parameter(endOfToday).count(1).query();
        junit.framework.Assert.assertTrue((String)"Found an artifact by lastModifiedTimestamp, but should *not* have!", (rset.size() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testResultSetAttributes() throws Exception {
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        for (int i = 0; i < 20; ++i) {
            this.addXmlDoc();
        }
        QueryResultSet rs = client.buildQuery("/s-ramp/core").count(2).startIndex(5).query();
        junit.framework.Assert.assertEquals((long)20L, (long)rs.getTotalResults());
        junit.framework.Assert.assertEquals((int)2, (int)rs.getItemsPerPage());
        junit.framework.Assert.assertEquals((int)5, (int)rs.getStartIndex());
    }

    @Test
    public void testQueryError() throws Exception {
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
        try {
            QueryResultSet rset = client.query("12345", 0, 20, "name", false);
            Assert.fail((String)("Expected a remote exception from the s-ramp server, but got: " + rset));
        }
        catch (SrampAtomException e) {
            junit.framework.Assert.assertEquals((String)"Invalid artifact set (step 2).", (String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArchiveUpload() throws Exception {
        SrampArchive archive = null;
        InputStream is1 = null;
        InputStream is2 = null;
        try {
            archive = new SrampArchive();
            String artifactFileName = "PO.xsd";
            is1 = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
            XsdDocument metaData = new XsdDocument();
            metaData.setName("PO.xsd");
            metaData.setVersion("1.1");
            metaData.setDescription("This is a test description (XSD).");
            archive.addEntry("schemas/PO.xsd", (BaseArtifactType)metaData, is1);
            artifactFileName = "PO.xml";
            is2 = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
            metaData = new XsdDocument();
            metaData.setName("PO.xml");
            metaData.setVersion("1.2");
            metaData.setDescription("This is a test description (XML).");
            archive.addEntry("core/PO.xml", (BaseArtifactType)metaData, is2);
        }
        catch (Exception e) {
            try {
                SrampArchive.closeQuietly((SrampArchive)archive);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is1);
                IOUtils.closeQuietly(is2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is1);
        IOUtils.closeQuietly((InputStream)is2);
        try {
            SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
            Map results = client.uploadBatch(archive);
            junit.framework.Assert.assertEquals((int)2, (int)results.size());
            junit.framework.Assert.assertTrue((boolean)results.keySet().contains("schemas/PO.xsd"));
            junit.framework.Assert.assertTrue((boolean)results.keySet().contains("core/PO.xml"));
            XsdDocument xsdDoc = (XsdDocument)results.get("schemas/PO.xsd");
            junit.framework.Assert.assertNotNull((Object)xsdDoc);
            junit.framework.Assert.assertEquals((String)"PO.xsd", (String)xsdDoc.getName());
            junit.framework.Assert.assertEquals((String)"1.1", (String)xsdDoc.getVersion());
            XmlDocument xmlDoc = (XmlDocument)results.get("core/PO.xml");
            junit.framework.Assert.assertNotNull((Object)xmlDoc);
            junit.framework.Assert.assertEquals((String)"PO.xml", (String)xmlDoc.getName());
            junit.framework.Assert.assertEquals((String)"1.2", (String)xmlDoc.getVersion());
        }
        finally {
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArchiveUploadWithError() throws Exception {
        SrampArchive archive = null;
        InputStream is1 = null;
        InputStream is2 = null;
        try {
            archive = new SrampArchive();
            String artifactFileName = "PO.xsd";
            is1 = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
            XsdDocument metaData = new XsdDocument();
            metaData.setName("PO.xsd");
            metaData.setVersion("1.1");
            metaData.setDescription("This is a test description (XSD).");
            archive.addEntry("schemas/PO.xsd", (BaseArtifactType)metaData, is1);
            artifactFileName = "PO.xml";
            metaData = new XsdDocument();
            metaData.setName("PO.xml");
            metaData.setVersion("1.2");
            metaData.setDescription("This is a test description (XML).");
            archive.addEntry("core/PO.xml", (BaseArtifactType)metaData, null);
        }
        catch (Exception e) {
            try {
                SrampArchive.closeQuietly((SrampArchive)archive);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is1);
                IOUtils.closeQuietly(is2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is1);
        IOUtils.closeQuietly(is2);
        try {
            SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
            Map results = client.uploadBatch(archive);
            junit.framework.Assert.assertEquals((int)2, (int)results.size());
            junit.framework.Assert.assertTrue((boolean)results.keySet().contains("schemas/PO.xsd"));
            junit.framework.Assert.assertTrue((boolean)results.keySet().contains("core/PO.xml"));
            XsdDocument xsdDoc = (XsdDocument)results.get("schemas/PO.xsd");
            junit.framework.Assert.assertNotNull((Object)xsdDoc);
            junit.framework.Assert.assertEquals((String)"PO.xsd", (String)xsdDoc.getName());
            junit.framework.Assert.assertEquals((String)"1.1", (String)xsdDoc.getVersion());
            Exception xmlError = (Exception)results.get("core/PO.xml");
            junit.framework.Assert.assertNotNull((Object)xmlError);
        }
        finally {
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addXmlDoc() throws Exception {
        String artifactFileName = "PO.xml";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        try {
            SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp"));
            client.uploadArtifact(ArtifactType.XmlDocument(), is, artifactFileName);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

