/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client.query;

import java.util.Date;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;

public class ArtifactSummary {
    private Entry entry;
    private BaseArtifactType artifact;

    public ArtifactSummary(Entry entry) {
        this.entry = entry;
    }

    public ArtifactType getType() {
        return SrampAtomUtils.getArtifactType((Entry)this.entry);
    }

    public String getUuid() {
        return this.entry.getId().toString();
    }

    public Date getLastModifiedTimestamp() {
        return this.entry.getUpdated();
    }

    public String getName() {
        return this.entry.getTitle();
    }

    public Date getCreatedTimestamp() {
        return this.entry.getPublished();
    }

    public String getCreatedBy() {
        return ((Person)this.entry.getAuthors().get(0)).getName();
    }

    public String getDescription() {
        return this.entry.getSummary();
    }

    public boolean isExtendedType() {
        return this.getType().isExtendedType();
    }

    public boolean isDerived() {
        return this.getType().isDerived();
    }

    public String getCustomPropertyValue(String propertyName) {
        if (this.artifact == null) {
            this.artifact = SrampAtomUtils.unwrapSrampArtifact((Entry)this.entry);
        }
        if (this.artifact != null) {
            return SrampModelUtils.getCustomProperty((BaseArtifactType)this.artifact, (String)propertyName);
        }
        return null;
    }
}

