/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.derived;

import java.io.InputStream;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.overlord.sramp.common.derived.WsdlDeriver;
import org.s_ramp.xmlns._2010.s_ramp.AttributeDeclaration;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactEnum;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Binding;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperation;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationInput;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperationOutput;
import org.s_ramp.xmlns._2010.s_ramp.ComplexTypeDeclaration;
import org.s_ramp.xmlns._2010.s_ramp.DerivedArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.ElementDeclaration;
import org.s_ramp.xmlns._2010.s_ramp.Message;
import org.s_ramp.xmlns._2010.s_ramp.NamedWsdlDerivedArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Operation;
import org.s_ramp.xmlns._2010.s_ramp.OperationInput;
import org.s_ramp.xmlns._2010.s_ramp.OperationOutput;
import org.s_ramp.xmlns._2010.s_ramp.Part;
import org.s_ramp.xmlns._2010.s_ramp.Port;
import org.s_ramp.xmlns._2010.s_ramp.PortType;
import org.s_ramp.xmlns._2010.s_ramp.SimpleTypeDeclaration;
import org.s_ramp.xmlns._2010.s_ramp.SoapAddress;
import org.s_ramp.xmlns._2010.s_ramp.SoapBinding;
import org.s_ramp.xmlns._2010.s_ramp.WsdlDocument;
import org.s_ramp.xmlns._2010.s_ramp.WsdlExtension;
import org.s_ramp.xmlns._2010.s_ramp.WsdlExtensionTarget;
import org.s_ramp.xmlns._2010.s_ramp.WsdlService;

public class WsdlDeriverTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeriverWsdl() throws Exception {
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        WsdlDeriver deriver = new WsdlDeriver();
        WsdlDocument testSrcArtifact = new WsdlDocument();
        testSrcArtifact.setArtifactType(BaseArtifactEnum.WSDL_DOCUMENT);
        testSrcArtifact.setUuid(UUID.randomUUID().toString());
        testSrcArtifact.setName("sample.wsdl");
        testSrcArtifact.setVersion("2012/09");
        testSrcArtifact.setContentEncoding("UTF-8");
        testSrcArtifact.setContentType("application/xml");
        testSrcArtifact.setContentSize(Long.valueOf(92779L));
        testSrcArtifact.setCreatedBy("anonymous");
        XMLGregorianCalendar xmlGC = dtFactory.newXMLGregorianCalendar(new GregorianCalendar());
        testSrcArtifact.setCreatedTimestamp(xmlGC);
        testSrcArtifact.setDescription("Sample WSDL.");
        testSrcArtifact.setLastModifiedBy("anonymous");
        testSrcArtifact.setLastModifiedTimestamp(xmlGC);
        InputStream testSrcContent = null;
        try {
            testSrcContent = this.getClass().getResourceAsStream("/sample-files/wsdl/deriver.wsdl");
            Collection derivedArtifacts = deriver.derive((BaseArtifactType)testSrcArtifact, testSrcContent);
            Assert.assertNotNull((Object)derivedArtifacts);
            Assert.assertEquals((int)35, (int)derivedArtifacts.size());
            HashMap<QName, Object> index = new HashMap<QName, Object>();
            for (BaseArtifactType da : derivedArtifacts) {
                NamedWsdlDerivedArtifactType arty;
                DerivedArtifactType artifact = (DerivedArtifactType)da;
                if (artifact instanceof NamedWsdlDerivedArtifactType) {
                    arty = (NamedWsdlDerivedArtifactType)artifact;
                    if (arty.getNCName() == null) continue;
                    index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), artifact);
                    continue;
                }
                if (artifact instanceof WsdlExtension) {
                    arty = (WsdlExtension)artifact;
                    index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), arty);
                    continue;
                }
                if (artifact instanceof ElementDeclaration) {
                    arty = (ElementDeclaration)artifact;
                    index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), artifact);
                    continue;
                }
                if (artifact instanceof AttributeDeclaration) {
                    arty = (AttributeDeclaration)artifact;
                    index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), artifact);
                    continue;
                }
                if (artifact instanceof SimpleTypeDeclaration) {
                    arty = (SimpleTypeDeclaration)artifact;
                    index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), artifact);
                    continue;
                }
                if (!(artifact instanceof ComplexTypeDeclaration)) continue;
                arty = (ComplexTypeDeclaration)artifact;
                index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), artifact);
            }
            DerivedArtifactType artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.MESSAGE.toString(), "findRequest"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"findRequest", (String)artifact.getName());
            Assert.assertEquals((String)"findRequest", (String)((Message)artifact).getNCName());
            Assert.assertEquals((String)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (String)((Message)artifact).getNamespace());
            Message message = (Message)artifact;
            Assert.assertEquals((int)1, (int)message.getPart().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.ELEMENT_DECLARATION.toString(), "findResponse"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"findResponse", (String)artifact.getName());
            Assert.assertEquals((String)"findResponse", (String)((ElementDeclaration)artifact).getNCName());
            Assert.assertEquals((String)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl/types", (String)((ElementDeclaration)artifact).getNamespace());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.SIMPLE_TYPE_DECLARATION.toString(), "keywordType"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"keywordType", (String)artifact.getName());
            Assert.assertEquals((String)"keywordType", (String)((SimpleTypeDeclaration)artifact).getNCName());
            Assert.assertEquals((String)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl/types", (String)((SimpleTypeDeclaration)artifact).getNamespace());
            String typeUuid = artifact.getUuid();
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.PART.toString(), "keyword"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"keyword", (String)artifact.getName());
            Part part = (Part)artifact;
            Assert.assertEquals((String)"keyword", (String)part.getNCName());
            Assert.assertEquals((String)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (String)part.getNamespace());
            Assert.assertNotNull((Object)part.getType());
            Assert.assertEquals((String)typeUuid, (String)part.getType().getValue());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.PORT_TYPE.toString(), "SamplePortType"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"SamplePortType", (String)artifact.getName());
            Assert.assertEquals((String)"SamplePortType", (String)((PortType)artifact).getNCName());
            Assert.assertEquals((String)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (String)((PortType)artifact).getNamespace());
            PortType portType = (PortType)artifact;
            Assert.assertEquals((int)2, (int)portType.getOperation().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.OPERATION.toString(), "find"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"find", (String)artifact.getName());
            Operation operation = (Operation)artifact;
            Assert.assertEquals((String)"find", (String)operation.getNCName());
            Assert.assertEquals((String)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (String)operation.getNamespace());
            Assert.assertNotNull((Object)operation.getInput());
            Assert.assertNotNull((Object)operation.getOutput());
            Assert.assertNotNull((Object)operation.getFault());
            Assert.assertEquals((int)2, (int)operation.getFault().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.OPERATION_INPUT.toString(), "findRequest"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"findRequest", (String)artifact.getName());
            OperationInput operationInput = (OperationInput)artifact;
            Assert.assertEquals((String)"findRequest", (String)operationInput.getNCName());
            Assert.assertNotNull((Object)operationInput.getMessage());
            Assert.assertNotNull((Object)operationInput.getMessage().getValue());
            Assert.assertEquals((String)((DerivedArtifactType)index.get(new QName(BaseArtifactEnum.MESSAGE.toString(), "findRequest"))).getUuid(), (String)operationInput.getMessage().getValue());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.OPERATION_OUTPUT.toString(), "findResponse"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"findResponse", (String)artifact.getName());
            OperationOutput operationOutput = (OperationOutput)artifact;
            Assert.assertEquals((String)"findResponse", (String)operationOutput.getNCName());
            Assert.assertNotNull((Object)operationOutput.getMessage());
            Assert.assertNotNull((Object)operationOutput.getMessage().getValue());
            Assert.assertEquals((String)((DerivedArtifactType)index.get(new QName(BaseArtifactEnum.MESSAGE.toString(), "findResponse"))).getUuid(), (String)operationOutput.getMessage().getValue());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.BINDING.toString(), "SampleBinding"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"SampleBinding", (String)artifact.getName());
            Assert.assertEquals((String)"SampleBinding", (String)((Binding)artifact).getNCName());
            Assert.assertEquals((String)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (String)((Binding)artifact).getNamespace());
            Binding binding = (Binding)artifact;
            Assert.assertEquals((int)2, (int)binding.getBindingOperation().size());
            Assert.assertEquals((int)1, (int)binding.getExtension().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.SOAP_BINDING.toString(), "binding"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"soap:binding", (String)artifact.getName());
            Assert.assertEquals((String)"binding", (String)((SoapBinding)artifact).getNCName());
            Assert.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)((SoapBinding)artifact).getNamespace());
            SoapBinding soapBinding = (SoapBinding)artifact;
            Assert.assertEquals((String)"document", (String)soapBinding.getStyle());
            Assert.assertEquals((String)"http://schemas.xmlsoap.org/soap/http", (String)soapBinding.getTransport());
            Assert.assertEquals((String)((WsdlExtensionTarget)binding.getExtension().get(0)).getValue(), (String)soapBinding.getUuid());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.BINDING_OPERATION.toString(), "find"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"find", (String)artifact.getName());
            BindingOperation bindingOperation = (BindingOperation)artifact;
            Assert.assertEquals((String)"find", (String)bindingOperation.getNCName());
            Assert.assertEquals((String)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (String)bindingOperation.getNamespace());
            Assert.assertNotNull((Object)bindingOperation.getInput());
            Assert.assertNotNull((Object)bindingOperation.getOutput());
            Assert.assertNotNull((Object)bindingOperation.getFault());
            Assert.assertEquals((int)2, (int)bindingOperation.getFault().size());
            Assert.assertNotNull((Object)bindingOperation.getOperation());
            Assert.assertEquals((String)operation.getUuid(), (String)bindingOperation.getOperation().getValue());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.BINDING_OPERATION_INPUT.toString(), "findRequest"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"findRequest", (String)artifact.getName());
            BindingOperationInput bindingOperationInput = (BindingOperationInput)artifact;
            Assert.assertEquals((String)"findRequest", (String)bindingOperationInput.getNCName());
            Assert.assertEquals((String)bindingOperation.getInput().getValue(), (String)bindingOperationInput.getUuid());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.BINDING_OPERATION_OUTPUT.toString(), "findResponse"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"findResponse", (String)artifact.getName());
            BindingOperationOutput bindingOperationOutput = (BindingOperationOutput)artifact;
            Assert.assertEquals((String)"findResponse", (String)bindingOperationOutput.getNCName());
            Assert.assertEquals((String)bindingOperation.getOutput().getValue(), (String)bindingOperationOutput.getUuid());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.WSDL_SERVICE.toString(), "SampleService"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"SampleService", (String)artifact.getName());
            Assert.assertEquals((String)"SampleService", (String)((WsdlService)artifact).getNCName());
            Assert.assertEquals((String)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (String)((WsdlService)artifact).getNamespace());
            WsdlService service = (WsdlService)artifact;
            Assert.assertEquals((int)1, (int)service.getPort().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.PORT.toString(), "SamplePort"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"SamplePort", (String)artifact.getName());
            Assert.assertEquals((String)"SamplePort", (String)((Port)artifact).getNCName());
            Port port = (Port)artifact;
            Assert.assertNotNull((Object)port.getBinding());
            Assert.assertEquals((String)port.getBinding().getValue(), (String)binding.getUuid());
            Assert.assertEquals((int)1, (int)port.getExtension().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.SOAP_ADDRESS.toString(), "address"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((String)"soap:address", (String)artifact.getName());
            Assert.assertEquals((String)"address", (String)((SoapAddress)artifact).getNCName());
            Assert.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)((SoapAddress)artifact).getNamespace());
            SoapAddress soapAddress = (SoapAddress)artifact;
            Assert.assertEquals((String)"http://localhost:8080/sample/sampleEP", (String)soapAddress.getSoapLocation());
            Assert.assertEquals((String)((WsdlExtensionTarget)port.getExtension().get(0)).getValue(), (String)soapAddress.getUuid());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(testSrcContent);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)testSrcContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHumanTaskWsdl() throws Exception {
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        WsdlDeriver deriver = new WsdlDeriver();
        WsdlDocument testSrcArtifact = new WsdlDocument();
        testSrcArtifact.setArtifactType(BaseArtifactEnum.WSDL_DOCUMENT);
        testSrcArtifact.setUuid(UUID.randomUUID().toString());
        testSrcArtifact.setName("ws-humantask-api.wsdl");
        testSrcArtifact.setVersion("200803");
        testSrcArtifact.setContentEncoding("UTF-8");
        testSrcArtifact.setContentType("application/xml");
        testSrcArtifact.setContentSize(Long.valueOf(92779L));
        testSrcArtifact.setCreatedBy("anonymous");
        XMLGregorianCalendar xmlGC = dtFactory.newXMLGregorianCalendar(new GregorianCalendar());
        testSrcArtifact.setCreatedTimestamp(xmlGC);
        testSrcArtifact.setDescription("Human Task WSDL.");
        testSrcArtifact.setLastModifiedBy("anonymous");
        testSrcArtifact.setLastModifiedTimestamp(xmlGC);
        InputStream testSrcContent = null;
        try {
            testSrcContent = this.getClass().getResourceAsStream("/sample-files/wsdl/ws-humantask-api.wsdl");
            Collection derivedArtifacts = deriver.derive((BaseArtifactType)testSrcArtifact, testSrcContent);
            Assert.assertNotNull((Object)derivedArtifacts);
            Assert.assertEquals((int)850, (int)derivedArtifacts.size());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(testSrcContent);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)testSrcContent);
    }
}

