/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.query.xpath;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.TreeSet;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.overlord.sramp.common.query.xpath.XPathParser;
import org.overlord.sramp.common.query.xpath.XPathParserException;
import org.overlord.sramp.common.query.xpath.ast.Query;
import org.overlord.sramp.common.query.xpath.visitors.XPathSerializationVisitor;
import org.overlord.sramp.common.query.xpath.visitors.XPathVisitor;

public class XPathParserTest {
    @Test
    public void testXPathParser() throws Exception {
        Collection<Properties> testCases = this.getTestCases();
        XPathParser parser = new XPathParser();
        XPathSerializationVisitor visitor = new XPathSerializationVisitor();
        for (Properties properties : testCases) {
            String testCaseName = properties.getProperty("testcase.name");
            String xpath = properties.getProperty("xpath");
            String expectedXpath = properties.getProperty("expected.xpath");
            String expectedErrorMessage = properties.getProperty("expected.errorMessage");
            try {
                Query query = parser.parseXPath(xpath);
                visitor.reset();
                query.accept((XPathVisitor)visitor);
                String actualXpath = visitor.getXPath();
                Assert.assertNotNull((String)("Case [" + testCaseName + "]"), (Object)query);
                Assert.assertEquals((String)("Case [" + testCaseName + "]"), (String)expectedXpath, (String)actualXpath);
            }
            catch (XPathParserException e) {
                Assert.assertNotNull((String)("Case [" + testCaseName + "] Got unexpected parse error: " + e.getMessage()), (Object)expectedErrorMessage);
                Assert.assertEquals((String)("Case [" + testCaseName + "]"), (String)expectedErrorMessage, (String)e.getMessage());
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable t) {
                Assert.fail((String)("Case [" + testCaseName + "] Got unexpected error: " + t.getMessage()));
            }
        }
        System.out.println("All " + testCases.size() + " XPath parser test cases passed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Properties> getTestCases() throws Exception {
        URL testCaseDirUrl = XPathParserTest.class.getResource("parser-test-cases");
        Assert.assertNotNull((String)"Failed to find test case directory!", (Object)testCaseDirUrl);
        File testCaseDir = new File(testCaseDirUrl.toURI());
        if (!testCaseDir.isDirectory()) {
            throw new Exception("Failed to find test case directory: " + testCaseDirUrl);
        }
        TreeSet testCaseFiles = FileUtils.listFiles((File)testCaseDir, (String[])new String[]{"properties"}, (boolean)true);
        testCaseFiles = new TreeSet(testCaseFiles);
        ArrayList<Properties> testCases = new ArrayList<Properties>(testCaseFiles.size());
        for (File testCaseFile : testCaseFiles) {
            Properties props = new Properties();
            FileReader reader = new FileReader(testCaseFile);
            try {
                props.load(reader);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            props.setProperty("testcase.name", testCaseFile.getName());
            testCases.add(props);
        }
        return testCases;
    }
}

