/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.derived;

import java.io.InputStream;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.AttributeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Binding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ComplexTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.NamedWsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Operation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Part;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Port;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SimpleTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapAddress;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapBinding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlExtension;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlExtensionTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlService;
import org.overlord.sramp.common.derived.WsdlDeriver;

public class WsdlDeriverTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeriverWsdl() throws Exception {
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        WsdlDeriver deriver = new WsdlDeriver();
        WsdlDocument testSrcArtifact = new WsdlDocument();
        testSrcArtifact.setArtifactType(BaseArtifactEnum.WSDL_DOCUMENT);
        testSrcArtifact.setUuid(UUID.randomUUID().toString());
        testSrcArtifact.setName("sample.wsdl");
        testSrcArtifact.setVersion("2012/09");
        testSrcArtifact.setContentEncoding("UTF-8");
        testSrcArtifact.setContentType("application/xml");
        testSrcArtifact.setContentSize(Long.valueOf(92779L));
        testSrcArtifact.setCreatedBy("anonymous");
        XMLGregorianCalendar xmlGC = dtFactory.newXMLGregorianCalendar(new GregorianCalendar());
        testSrcArtifact.setCreatedTimestamp(xmlGC);
        testSrcArtifact.setDescription("Sample WSDL.");
        testSrcArtifact.setLastModifiedBy("anonymous");
        testSrcArtifact.setLastModifiedTimestamp(xmlGC);
        InputStream testSrcContent = null;
        try {
            testSrcContent = this.getClass().getResourceAsStream("/sample-files/wsdl/deriver.wsdl");
            Collection derivedArtifacts = deriver.derive((BaseArtifactType)testSrcArtifact, testSrcContent);
            Assert.assertNotNull((Object)derivedArtifacts);
            Assert.assertEquals((long)35L, (long)derivedArtifacts.size());
            HashMap<QName, Object> index = new HashMap<QName, Object>();
            for (BaseArtifactType da : derivedArtifacts) {
                NamedWsdlDerivedArtifactType arty;
                DerivedArtifactType artifact = (DerivedArtifactType)da;
                if (artifact instanceof NamedWsdlDerivedArtifactType) {
                    arty = (NamedWsdlDerivedArtifactType)artifact;
                    if (arty.getNCName() == null) continue;
                    index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), artifact);
                    continue;
                }
                if (artifact instanceof WsdlExtension) {
                    arty = (WsdlExtension)artifact;
                    index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), arty);
                    continue;
                }
                if (artifact instanceof ElementDeclaration) {
                    arty = (ElementDeclaration)artifact;
                    index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), artifact);
                    continue;
                }
                if (artifact instanceof AttributeDeclaration) {
                    arty = (AttributeDeclaration)artifact;
                    index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), artifact);
                    continue;
                }
                if (artifact instanceof SimpleTypeDeclaration) {
                    arty = (SimpleTypeDeclaration)artifact;
                    index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), artifact);
                    continue;
                }
                if (!(artifact instanceof ComplexTypeDeclaration)) continue;
                arty = (ComplexTypeDeclaration)artifact;
                index.put(new QName(arty.getArtifactType().toString(), arty.getNCName()), artifact);
            }
            DerivedArtifactType artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.MESSAGE.toString(), "findRequest"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"findRequest", (Object)artifact.getName());
            Assert.assertEquals((Object)"findRequest", (Object)((Message)artifact).getNCName());
            Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)((Message)artifact).getNamespace());
            Message message = (Message)artifact;
            Assert.assertEquals((long)1L, (long)message.getPart().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.ELEMENT_DECLARATION.toString(), "findResponse"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"findResponse", (Object)artifact.getName());
            Assert.assertEquals((Object)"findResponse", (Object)((ElementDeclaration)artifact).getNCName());
            Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl/types", (Object)((ElementDeclaration)artifact).getNamespace());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.SIMPLE_TYPE_DECLARATION.toString(), "keywordType"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"keywordType", (Object)artifact.getName());
            Assert.assertEquals((Object)"keywordType", (Object)((SimpleTypeDeclaration)artifact).getNCName());
            Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl/types", (Object)((SimpleTypeDeclaration)artifact).getNamespace());
            String typeUuid = artifact.getUuid();
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.PART.toString(), "keyword"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"keyword", (Object)artifact.getName());
            Part part = (Part)artifact;
            Assert.assertEquals((Object)"keyword", (Object)part.getNCName());
            Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)part.getNamespace());
            Assert.assertNotNull((Object)part.getType());
            Assert.assertEquals((Object)typeUuid, (Object)part.getType().getValue());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.PORT_TYPE.toString(), "SamplePortType"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"SamplePortType", (Object)artifact.getName());
            Assert.assertEquals((Object)"SamplePortType", (Object)((PortType)artifact).getNCName());
            Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)((PortType)artifact).getNamespace());
            PortType portType = (PortType)artifact;
            Assert.assertEquals((long)2L, (long)portType.getOperation().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.OPERATION.toString(), "find"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"find", (Object)artifact.getName());
            Operation operation = (Operation)artifact;
            Assert.assertEquals((Object)"find", (Object)operation.getNCName());
            Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)operation.getNamespace());
            Assert.assertNotNull((Object)operation.getInput());
            Assert.assertNotNull((Object)operation.getOutput());
            Assert.assertNotNull((Object)operation.getFault());
            Assert.assertEquals((long)2L, (long)operation.getFault().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.OPERATION_INPUT.toString(), "findRequest"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"findRequest", (Object)artifact.getName());
            OperationInput operationInput = (OperationInput)artifact;
            Assert.assertEquals((Object)"findRequest", (Object)operationInput.getNCName());
            Assert.assertNotNull((Object)operationInput.getMessage());
            Assert.assertNotNull((Object)operationInput.getMessage().getValue());
            Assert.assertEquals((Object)((DerivedArtifactType)index.get(new QName(BaseArtifactEnum.MESSAGE.toString(), "findRequest"))).getUuid(), (Object)operationInput.getMessage().getValue());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.OPERATION_OUTPUT.toString(), "findResponse"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"findResponse", (Object)artifact.getName());
            OperationOutput operationOutput = (OperationOutput)artifact;
            Assert.assertEquals((Object)"findResponse", (Object)operationOutput.getNCName());
            Assert.assertNotNull((Object)operationOutput.getMessage());
            Assert.assertNotNull((Object)operationOutput.getMessage().getValue());
            Assert.assertEquals((Object)((DerivedArtifactType)index.get(new QName(BaseArtifactEnum.MESSAGE.toString(), "findResponse"))).getUuid(), (Object)operationOutput.getMessage().getValue());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.BINDING.toString(), "SampleBinding"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"SampleBinding", (Object)artifact.getName());
            Assert.assertEquals((Object)"SampleBinding", (Object)((Binding)artifact).getNCName());
            Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)((Binding)artifact).getNamespace());
            Binding binding = (Binding)artifact;
            Assert.assertEquals((long)2L, (long)binding.getBindingOperation().size());
            Assert.assertEquals((long)1L, (long)binding.getExtension().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.SOAP_BINDING.toString(), "binding"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"soap:binding", (Object)artifact.getName());
            Assert.assertEquals((Object)"binding", (Object)((SoapBinding)artifact).getNCName());
            Assert.assertEquals((Object)"http://schemas.xmlsoap.org/wsdl/soap/", (Object)((SoapBinding)artifact).getNamespace());
            SoapBinding soapBinding = (SoapBinding)artifact;
            Assert.assertEquals((Object)"document", (Object)soapBinding.getStyle());
            Assert.assertEquals((Object)"http://schemas.xmlsoap.org/soap/http", (Object)soapBinding.getTransport());
            Assert.assertEquals((Object)((WsdlExtensionTarget)binding.getExtension().get(0)).getValue(), (Object)soapBinding.getUuid());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.BINDING_OPERATION.toString(), "find"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"find", (Object)artifact.getName());
            BindingOperation bindingOperation = (BindingOperation)artifact;
            Assert.assertEquals((Object)"find", (Object)bindingOperation.getNCName());
            Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)bindingOperation.getNamespace());
            Assert.assertNotNull((Object)bindingOperation.getInput());
            Assert.assertNotNull((Object)bindingOperation.getOutput());
            Assert.assertNotNull((Object)bindingOperation.getFault());
            Assert.assertEquals((long)2L, (long)bindingOperation.getFault().size());
            Assert.assertNotNull((Object)bindingOperation.getOperation());
            Assert.assertEquals((Object)operation.getUuid(), (Object)bindingOperation.getOperation().getValue());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.BINDING_OPERATION_INPUT.toString(), "findRequest"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"findRequest", (Object)artifact.getName());
            BindingOperationInput bindingOperationInput = (BindingOperationInput)artifact;
            Assert.assertEquals((Object)"findRequest", (Object)bindingOperationInput.getNCName());
            Assert.assertEquals((Object)bindingOperation.getInput().getValue(), (Object)bindingOperationInput.getUuid());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.BINDING_OPERATION_OUTPUT.toString(), "findResponse"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"findResponse", (Object)artifact.getName());
            BindingOperationOutput bindingOperationOutput = (BindingOperationOutput)artifact;
            Assert.assertEquals((Object)"findResponse", (Object)bindingOperationOutput.getNCName());
            Assert.assertEquals((Object)bindingOperation.getOutput().getValue(), (Object)bindingOperationOutput.getUuid());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.WSDL_SERVICE.toString(), "SampleService"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"SampleService", (Object)artifact.getName());
            Assert.assertEquals((Object)"SampleService", (Object)((WsdlService)artifact).getNCName());
            Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)((WsdlService)artifact).getNamespace());
            WsdlService service = (WsdlService)artifact;
            Assert.assertEquals((long)1L, (long)service.getPort().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.PORT.toString(), "SamplePort"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"SamplePort", (Object)artifact.getName());
            Assert.assertEquals((Object)"SamplePort", (Object)((Port)artifact).getNCName());
            Port port = (Port)artifact;
            Assert.assertNotNull((Object)port.getBinding());
            Assert.assertEquals((Object)port.getBinding().getValue(), (Object)binding.getUuid());
            Assert.assertEquals((long)1L, (long)port.getExtension().size());
            artifact = (DerivedArtifactType)index.get(new QName(BaseArtifactEnum.SOAP_ADDRESS.toString(), "address"));
            Assert.assertNotNull((Object)artifact);
            Assert.assertEquals((Object)"soap:address", (Object)artifact.getName());
            Assert.assertEquals((Object)"address", (Object)((SoapAddress)artifact).getNCName());
            Assert.assertEquals((Object)"http://schemas.xmlsoap.org/wsdl/soap/", (Object)((SoapAddress)artifact).getNamespace());
            SoapAddress soapAddress = (SoapAddress)artifact;
            Assert.assertEquals((Object)"http://localhost:8080/sample/sampleEP", (Object)soapAddress.getSoapLocation());
            Assert.assertEquals((Object)((WsdlExtensionTarget)port.getExtension().get(0)).getValue(), (Object)soapAddress.getUuid());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(testSrcContent);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)testSrcContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHumanTaskWsdl() throws Exception {
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        WsdlDeriver deriver = new WsdlDeriver();
        WsdlDocument testSrcArtifact = new WsdlDocument();
        testSrcArtifact.setArtifactType(BaseArtifactEnum.WSDL_DOCUMENT);
        testSrcArtifact.setUuid(UUID.randomUUID().toString());
        testSrcArtifact.setName("ws-humantask-api.wsdl");
        testSrcArtifact.setVersion("200803");
        testSrcArtifact.setContentEncoding("UTF-8");
        testSrcArtifact.setContentType("application/xml");
        testSrcArtifact.setContentSize(Long.valueOf(92779L));
        testSrcArtifact.setCreatedBy("anonymous");
        XMLGregorianCalendar xmlGC = dtFactory.newXMLGregorianCalendar(new GregorianCalendar());
        testSrcArtifact.setCreatedTimestamp(xmlGC);
        testSrcArtifact.setDescription("Human Task WSDL.");
        testSrcArtifact.setLastModifiedBy("anonymous");
        testSrcArtifact.setLastModifiedTimestamp(xmlGC);
        InputStream testSrcContent = null;
        try {
            testSrcContent = this.getClass().getResourceAsStream("/sample-files/wsdl/ws-humantask-api.wsdl");
            Collection derivedArtifacts = deriver.derive((BaseArtifactType)testSrcArtifact, testSrcContent);
            Assert.assertNotNull((Object)derivedArtifacts);
            Assert.assertEquals((long)850L, (long)derivedArtifacts.size());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(testSrcContent);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)testSrcContent);
    }
}

