/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.query.xpath;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.common.query.xpath.StaticNamespaceContext;

public class StaticNamespaceContextTest {
    @Test
    public void testGetNamespaceURI() {
        StaticNamespaceContext ctx = new StaticNamespaceContext();
        ctx.addMapping("ns1", "urn:ns1");
        ctx.addMapping("ns1-1", "urn:ns1");
        ctx.addMapping("ns2", "urn:ns2");
        ctx.addMapping("ns3", "urn:ns3");
        Assert.assertEquals((Object)"urn:ns2", (Object)ctx.getNamespaceURI("ns2"));
        Assert.assertEquals((Object)"urn:ns3", (Object)ctx.getNamespaceURI("ns3"));
        Assert.assertNull((Object)ctx.getNamespaceURI("ns4"));
    }

    @Test
    public void testGetPrefix() {
        StaticNamespaceContext ctx = new StaticNamespaceContext();
        ctx.addMapping("ns1", "urn:ns1");
        ctx.addMapping("ns1-1", "urn:ns1");
        ctx.addMapping("ns2", "urn:ns2");
        ctx.addMapping("ns3", "urn:ns3");
        Assert.assertEquals((Object)"ns2", (Object)ctx.getPrefix("urn:ns2"));
        Assert.assertEquals((Object)"ns3", (Object)ctx.getPrefix("urn:ns3"));
        Assert.assertNull((Object)ctx.getPrefix("urn:ns4"));
    }

    @Test
    public void testGetPrefixes() {
        StaticNamespaceContext ctx = new StaticNamespaceContext();
        ctx.addMapping("ns1", "urn:ns1");
        ctx.addMapping("ns1-1", "urn:ns1");
        ctx.addMapping("ns2", "urn:ns2");
        ctx.addMapping("ns3", "urn:ns3");
        Assert.assertTrue((boolean)ctx.getPrefixes("urn:ns2").hasNext());
        Assert.assertTrue((boolean)ctx.getPrefixes("urn:ns3").hasNext());
        Assert.assertFalse((boolean)ctx.getPrefixes("urn:ns4").hasNext());
        Iterator iter1 = ctx.getPrefixes("urn:ns1");
        Assert.assertTrue((boolean)iter1.hasNext());
        Assert.assertTrue((boolean)((String)iter1.next()).startsWith("ns1"));
        Assert.assertTrue((boolean)iter1.hasNext());
        Assert.assertTrue((boolean)((String)iter1.next()).startsWith("ns1"));
    }

    @Test
    public void testRemoveMapping() {
        StaticNamespaceContext ctx = new StaticNamespaceContext();
        ctx.addMapping("ns1", "urn:ns1");
        ctx.addMapping("ns1-1", "urn:ns1");
        ctx.addMapping("ns2", "urn:ns2");
        ctx.addMapping("ns3", "urn:ns3");
        Assert.assertEquals((Object)"urn:ns2", (Object)ctx.getNamespaceURI("ns2"));
        Assert.assertEquals((Object)"urn:ns3", (Object)ctx.getNamespaceURI("ns3"));
        Assert.assertNull((Object)ctx.getNamespaceURI("ns4"));
        ctx.removeMapping("ns2");
        Assert.assertNull((Object)ctx.getNamespaceURI("ns2"));
        Assert.assertEquals((Object)"urn:ns3", (Object)ctx.getNamespaceURI("ns3"));
        Assert.assertNull((Object)ctx.getNamespaceURI("ns4"));
    }
}

