/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.overlord.sramp.common.SystemPropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sramp {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static Configuration configuration = null;

    public Sramp() {
        if (configuration == null) {
            this.read();
        }
    }

    public synchronized void read() {
        try {
            CompositeConfiguration config = new CompositeConfiguration();
            config.addConfiguration((Configuration)new SystemPropertiesConfiguration());
            String configFile = config.getString("sramp.config.file.name");
            Long refreshDelay = config.getLong("sramp.config.file.refresh", 5000L);
            URL url = this.findSrampConfig(configFile);
            if (url == null) {
                this.log.warn("Cannot find " + configFile);
            } else {
                PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(url);
                FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
                fileChangedReloadingStrategy.setRefreshDelay(refreshDelay.longValue());
                propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
                config.addConfiguration((Configuration)propertiesConfiguration);
            }
            configuration = config;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private URL findSrampConfig(String configFile) throws MalformedURLException {
        if (configFile != null) {
            URL fromClasspath = Sramp.class.getClassLoader().getResource(configFile);
            if (fromClasspath != null) {
                return fromClasspath;
            }
            File file = new File(configFile);
            if (file.isFile()) {
                return file.toURI().toURL();
            }
        } else {
            File cfile;
            File dirFile;
            File cfile2;
            File dirFile2;
            File cfile3;
            File dirFile3;
            String userHomeDir = System.getProperty("user.home");
            if (userHomeDir != null && (dirFile3 = new File(userHomeDir)).isDirectory() && (cfile3 = new File(dirFile3, "sramp.properties")).isFile()) {
                return cfile3.toURI().toURL();
            }
            String jbossConfigDir = System.getProperty("jboss.server.config.dir");
            if (jbossConfigDir != null && (dirFile2 = new File(jbossConfigDir)).isDirectory() && (cfile2 = new File(dirFile2, "sramp.properties")).isFile()) {
                return cfile2.toURI().toURL();
            }
            String jbossConfigUrl = System.getProperty("jboss.server.config.url");
            if (jbossConfigUrl != null && (dirFile = new File(jbossConfigUrl)).isDirectory() && (cfile = new File(dirFile, "sramp.properties")).isFile()) {
                return cfile.toURI().toURL();
            }
        }
        return null;
    }

    public String getBaseUrl(String requestUrl) {
        String baseUrl = "http://localhost:8080/s-ramp-server";
        if (requestUrl != null) {
            int index = requestUrl.indexOf("/s-ramp/");
            if (index < 0) {
                index = requestUrl.indexOf("/s-ramp");
            }
            if (index > 0) {
                baseUrl = requestUrl.substring(0, index);
            }
        }
        return configuration.getString("sramp.config.baseurl", baseUrl);
    }

    public boolean isAuditingEnabled() {
        return configuration.getBoolean("sramp.config.auditing.enabled", true);
    }

    public boolean isDerivedArtifactAuditingEnabled() {
        return configuration.getBoolean("sramp.config.auditing.enabled-derived", true);
    }

    public String getAuditUser() {
        return configuration.getString("sramp.config.auditing.user", "auditor");
    }

    public String getAuditPassword() {
        return configuration.getString("sramp.config.auditing.password", "overlord-auditor");
    }
}

