/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.derived;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.derived.ArtifactDeriver;
import org.overlord.sramp.common.query.xpath.StaticNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractXmlDeriver
implements ArtifactDeriver {
    @Override
    public Collection<BaseArtifactType> derive(BaseArtifactType artifact, InputStream content) throws IOException {
        Collection<BaseArtifactType> derivedArtifacts = this.createDerivedArtifactCollection();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(content);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            StaticNamespaceContext nsCtx = new StaticNamespaceContext();
            this.configureNamespaceMappings(nsCtx);
            xpath.setNamespaceContext(nsCtx);
            Element rootElement = document.getDocumentElement();
            this.derive(derivedArtifacts, artifact, rootElement, xpath);
            for (BaseArtifactType derivedArtifact : derivedArtifacts) {
                if (derivedArtifact instanceof DerivedArtifactType) {
                    DerivedArtifactType dat = (DerivedArtifactType)derivedArtifact;
                    if (dat.getRelatedDocument() != null) continue;
                    DocumentArtifactTarget related = new DocumentArtifactTarget();
                    related.setValue(artifact.getUuid());
                    related.setArtifactType(DocumentArtifactEnum.fromValue((BaseArtifactEnum)artifact.getArtifactType()));
                    dat.setRelatedDocument(related);
                    continue;
                }
                Relationship genericRelationship = SrampModelUtils.getGenericRelationship(derivedArtifact, "relatedDocument");
                if (genericRelationship != null) continue;
                SrampModelUtils.addGenericRelationship(derivedArtifact, "relatedDocument", artifact.getUuid());
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return derivedArtifacts;
    }

    protected Collection<BaseArtifactType> createDerivedArtifactCollection() {
        return new ArrayList<BaseArtifactType>();
    }

    protected Object query(XPath xpath, Element context, String query, QName returnType) throws XPathExpressionException {
        XPathExpression expr = xpath.compile(query);
        return expr.evaluate(context, returnType);
    }

    protected abstract void derive(Collection<BaseArtifactType> var1, BaseArtifactType var2, Element var3, XPath var4) throws IOException;

    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
    }
}

