/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.derived;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.io.FileUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.derived.ArtifactDeriver;
import org.overlord.sramp.common.derived.DeriverProvider;
import org.overlord.sramp.common.derived.LinkerContext;
import org.overlord.sramp.common.derived.PolicyDeriver;
import org.overlord.sramp.common.derived.WsdlDeriver;
import org.overlord.sramp.common.derived.XsdDeriver;

public class ArtifactDeriverFactory {
    private static Map<ArtifactTypeEnum, ArtifactDeriver> derivers = new HashMap<ArtifactTypeEnum, ArtifactDeriver>();
    private static Map<String, ArtifactDeriver> extendedDerivers = new HashMap<String, ArtifactDeriver>();
    private static ArtifactDeriver nullDeriver;

    private static void loadBuiltInDerivers() {
        derivers.put(ArtifactTypeEnum.XsdDocument, new XsdDeriver());
        derivers.put(ArtifactTypeEnum.WsdlDocument, new WsdlDeriver());
        derivers.put(ArtifactTypeEnum.PolicyDocument, new PolicyDeriver());
    }

    private static void loadExtendedDerivers() {
        File directory;
        LinkedList<ClassLoader> loaders = new LinkedList<ClassLoader>();
        loaders.add(Thread.currentThread().getContextClassLoader());
        String customDeriverDirPath = System.getProperty("sramp.derivers.customDir");
        if (customDeriverDirPath != null && customDeriverDirPath.trim().length() > 0 && (directory = new File(customDeriverDirPath)).isDirectory()) {
            ArrayList<URL> jarURLs = new ArrayList<URL>();
            Collection jarFiles = FileUtils.listFiles((File)directory, (String[])new String[]{"jar"}, (boolean)false);
            for (File jarFile : jarFiles) {
                try {
                    URL jarUrl = jarFile.toURI().toURL();
                    jarURLs.add(jarUrl);
                }
                catch (MalformedURLException e) {}
            }
            URL[] urls = jarURLs.toArray(new URL[jarURLs.size()]);
            URLClassLoader jarCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            loaders.add(jarCL);
        }
        for (ClassLoader loader : loaders) {
            for (DeriverProvider provider : ServiceLoader.load(DeriverProvider.class, loader)) {
                Map<String, ArtifactDeriver> derivers = provider.createArtifactDerivers();
                if (derivers == null || derivers.isEmpty()) continue;
                extendedDerivers.putAll(derivers);
            }
        }
    }

    public static final ArtifactDeriver createArtifactDeriver(ArtifactType artifactType) {
        ArtifactDeriver deriver = null;
        deriver = artifactType.isExtendedType() ? extendedDerivers.get(artifactType.getExtendedType()) : derivers.get((Object)artifactType.getArtifactType());
        if (deriver == null) {
            deriver = nullDeriver;
        }
        return deriver;
    }

    static {
        ArtifactDeriverFactory.loadBuiltInDerivers();
        ArtifactDeriverFactory.loadExtendedDerivers();
        nullDeriver = new ArtifactDeriver(){

            @Override
            public Collection<BaseArtifactType> derive(BaseArtifactType artifact, InputStream content) {
                return Collections.EMPTY_SET;
            }

            @Override
            public void link(LinkerContext context, BaseArtifactType sourceArtifact, Collection<BaseArtifactType> derivedArtifacts) {
            }
        };
    }
}

