/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common;

import org.apache.commons.configuration.Configuration;
import org.overlord.commons.config.ConfigurationFactory;
import org.overlord.commons.config.JBossServer;

public class Sramp {
    private static Configuration configuration = null;

    public String getBaseUrl(String requestUrl) {
        String baseUrl = null;
        if (requestUrl != null) {
            int index = requestUrl.indexOf("/s-ramp/");
            if (index < 0) {
                index = requestUrl.indexOf("/s-ramp");
            }
            if (index > 0) {
                baseUrl = requestUrl.substring(0, index);
            }
        }
        if (baseUrl == null) {
            baseUrl = JBossServer.getBaseUrl() + "/s-ramp-server";
        }
        return configuration.getString("sramp.config.baseurl", baseUrl);
    }

    public boolean isAuditingEnabled() {
        return configuration.getBoolean("sramp.config.auditing.enabled", true);
    }

    public boolean isDerivedArtifactAuditingEnabled() {
        return configuration.getBoolean("sramp.config.auditing.enabled-derived", true);
    }

    public String getConfigProperty(String propertyName, String propertyDefault) {
        return configuration.getString(propertyName, propertyDefault);
    }

    static {
        String configFile = System.getProperty("sramp.config.file.name");
        String refreshDelayStr = System.getProperty("sramp.config.file.refresh");
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        configuration = ConfigurationFactory.createConfig((String)configFile, (String)"sramp.properties", (Long)refreshDelay, null, null);
    }
}

